const co = require('co');
const composeModel = require('../model/Compose');
const ArticleModel = require('../model/Article');
const MultiArticle = require('../model/MultiArticle');

function convertObject(o, coverAttr) {
    let url = '';
    if (coverAttr) {
        url = o[coverAttr];
    } else {
        if (o.cover) {
            if (o.cover.type === 'select') {
                const urls = o.cover.url.filter(urlObj => urlObj);
                url = urls && urls[0].source || '';
            } else {
                url = o.cover && o.cover.url || '';
            }
        }
    }
    return {
        content: o.content,
        cover: url && {
            url,
            type: 'normal'
        } || undefined,
        title: o.title
    };
}

module.exports = {
    addArticle: co.wrap(function*(ctx, next) {
        const articleList = yield composeModel.find({}, {
            sort: 'no'
        }).catch(e => {
            console.log(e);
        });
        if (articleList.map(item => item.source.id).includes(ctx.message.data.source.id)) {
            throw new Error('该文章已经存在，请勿重复添加');
        }
        const article = yield composeModel.addArticle(ctx.message.data);
        ctx.body = {
            article
        };
        yield next();
    }),
    getArticleList: co.wrap(function*(ctx, next) {
        // ctx.log('获取合成器文章列表成功');
        const articleList = yield composeModel.find({}, {
            sort: 'no'
        }).catch(e => {
            console.log(e);
        });
        ctx.body = {
            rows: articleList,
        };
        yield next();
    }),
    removeArticle: co.wrap(function* (ctx, next) {
        yield composeModel.deleteOne({
            _id: ctx.message.data._id
        });
        yield next();
    }),
    updateArticle: co.wrap(function* (ctx, next) {
        yield composeModel.updateArticle(ctx.message.query, ctx.message.data);
        yield next();
    }),
    done: co.wrap(function* (ctx, next) {
        const result = {
            weixin: new Array(ctx.message.articleList.length),
            qq: new Array(ctx.message.articleList.length)
        };
        const localComposeArticles = [];
        const remoteComposeArticles = [];
        ctx.message.articleList.forEach(article => {
            if (article.type === '0') {
                localComposeArticles.push(article);
            }
            if (article.type === '1') {
                remoteComposeArticles.push(article);
            }
        });
        const localArticles = yield Promise.all(localComposeArticles.map(article => {
            return ArticleModel.findOne({
                _id: article.source.id
            });
        })).catch(e => console.log(e));
        localArticles.forEach((article, index) => {
            if (article.weixin && article.qq) {
                result.weixin[localComposeArticles[index].no - 1] = convertObject(article.weixin);
                result.qq[localComposeArticles[index].no - 1] = convertObject(article.qq);
            } else {
                result.weixin[localComposeArticles[index].no - 1] = convertObject(article[article.platform_list[0]]);
                result.qq[localComposeArticles[index].no - 1] = convertObject(article[article.platform_list[0]]);
            }
        });
        const remoteArticles = yield Promise.all(remoteComposeArticles.map(article => {
            // return ctx.app.PlatformApi.WeiXin.fetchWeiXinArticle(article.source.url).catch(() => null);
            return ctx.app.sendMessage({
                name: '/article/fetch',
                url: article.source.url
            }).then(res => (res.body)).catch(() => null);
        }));
        remoteArticles.forEach((article, index) => {
            if (article) {
                result.weixin[remoteComposeArticles[index].no - 1] = convertObject(article, 'headImg');
                result.qq[remoteComposeArticles[index].no - 1] = convertObject(article, 'headImg');
            }
        });
        ctx.log(result);
        const article = yield MultiArticle.saveArticle({}, Object.assign({}, result));
        ctx.body = {
            article,
        };
        yield next();
    }),
};
