const co = require('co');
const AppConfig = require('../model/AppConfig');
const process = require('process');

module.exports = {
    appData: co.wrap(function*(ctx, next) {
        const app = ctx.app;
        let config = yield AppConfig.findOne();
        console.log('::', config);
        if (!config) {
            config = AppConfig.create({
                createtime: new Date()
            });
            yield config.save();
        }
        config.clientId = app.clientId;
        config.cwd = process.cwd();
        config.homeDir = app.homeDir;
        config.materialDir = app.materialDir;
        ctx.body = config.toJSON();
        ctx.body.manifest = app.manifest;
        yield next();
    }),

    saveConfig: co.wrap(function*(ctx, next) {
        const config = yield AppConfig.findOne({});
        Object.assign(config, ctx.message.config);
        console.log('save config::', config);
        // 删除_schema否则会报错
        delete config._schema;
        // 清除undefined否则会报错，放在preSave再次打开应用还会出错
        Object.keys(config).forEach(key => {
            if (config[key] === undefined) {
                delete config[key];
            }
        });
        yield config.save();
        ctx.body = config.toJSON();
        yield next();
    }),

    reset: co.wrap(function*(ctx, next) {
        const config = yield AppConfig.findOne();
        Object.assign(config, {
            username: null,
            nickname: null,
            token: null,
            userId: null,
            filePath: null,
            is_verify_mobile: null,
            mobile: null,
        });
        yield config.save();
        ctx.body = config.toJSON();
        yield next();
    })
};
