const co = require('co');

module.exports = {
    getSystemStyle: co.wrap(function*(ctx, next) {
        try {
            const res = yield ctx.app.WxbApi.getStyleSystemList({
                not_declare: true
            });
            ctx.body = res;
        } catch (e) {
            ctx.body = {
                err: 1,
                msg: e
            };
        }
        yield next();
    }),

    getMyStyleList: co.wrap(function*(ctx, next) {
        try {
            const res = yield ctx.app.WxbApi.getStyleMyList(ctx.message.data, ctx.message.token);
            ctx.body = res;
        } catch (e) {
            ctx.body = {
                err: 1,
                msg: e
            };
        }

        yield next();
    }),

    getStyleTags: co.wrap(function*(ctx, next) {
        try {
            const res = yield ctx.app.WxbApi.getStyleTags(ctx.message.token);
            ctx.body = res;
        } catch (e) {
            ctx.body = {
                err: 1,
                msg: e
            };
        }
        yield next();
    }),

    getStyleTagList: co.wrap(function*(ctx, next) {
        try {
            const res = yield ctx.app.WxbApi.getStyleTagList(ctx.message.data);
            ctx.body = res;
        } catch (e) {
            ctx.body = {
                err: 1,
                msg: e
            };
        }

        yield next();
    }),

    saveMyStyle: co.wrap(function*(ctx, next) {
        try {
            const res = yield ctx.app.WxbApi.saveMyStyle(ctx.message.data, ctx.message.token);
            ctx.body = res;
        } catch (e) {
            ctx.body = {
                err: 1,
                msg: e
            };
        }

        yield next();
    }),

    deleteMyStyle: co.wrap(function*(ctx, next) {
        try {
            const res = yield ctx.app.WxbApi.removeMyStyle(ctx.message.data, ctx.message.token);
            ctx.body = res;
        } catch (e) {
            ctx.body = {
                err: 1,
                msg: e
            };
        }

        yield next();
    }),

    updateStyleTag: co.wrap(function*(ctx, next) {
        try {
            const res = yield ctx.app.WxbApi.saveMyStyleTag(ctx.message.data, ctx.message.token);
            ctx.body = res;
        } catch (e) {
            ctx.body = {
                err: 1,
                msg: e
            };
        }

        yield next();
    }),

    deleteStyleTag: co.wrap(function*(ctx, next) {
        try {
            const res = yield ctx.app.WxbApi.removeMyStyleTag(ctx.message.data, ctx.message.token);
            ctx.body = res;
        } catch (e) {
            ctx.body = {
                err: 1,
                msg: e
            };
        }

        yield next();
    }),

    collectStyle: co.wrap(function*(ctx, next) {
        try {
            const res = yield ctx.app.WxbApi.collectStyle(ctx.message.data, ctx.message.token);
            ctx.body = res;
        } catch (e) {
            ctx.body = {
                err: 1,
                msg: e
            };
        }

        yield next();
    })
};
