const co = require('co');
const util = require('../modules/util');
const cheerio = require('cheerio');

module.exports = {
    fetchYoukuVideo: co.wrap(function*(ctx, next) {
        const { url, types } = ctx.message;
        if (!types.includes('youku') || !/http:\/\/v.youku.com\/v_show\/(.*)?.html/.test(url)) {
            yield next();
            return;
        }
        try {
            const html = yield util.Http.get(url);
            const data = util.Base.parseObjectString(html.match(/var PageConfig = ([.\s\S]*?)<\/script>/)[1]);
            const $ = cheerio.load(html);
            const title = $('#subtitle').attr('title');
            ctx.body = {
                originalUrl: `http://v.youku.com/v_show/id_${data.currentEncodeVid}.html`,
                playerUrl: `http://player.youku.com/embed/${data.currentEncodeVid}`,
                provider: 'youku',
                title: title,
                vid: data.currentEncodeVid,
                swfUrl: `http://player.youku.com/player.php/sid/${data.currentEncodeVid}/v.swf`
            };
            yield next();
            return;
        } catch (e) {
            console.log(e);
        }
        yield next();
    }),

    fetchQQVideo: co.wrap(function*(ctx, next) {
        const { url, types } = ctx.message;
        if (!types.includes('qq') || !/http[s]?:\/\/v.qq.com\/.*\/(.*).html/.test(url)) {
            yield next();
            return;
        }
        try {
            const html = yield util.Http.get(url);
            const $ = cheerio.load(html);
            const data = util.Base.parseObjectString(html.match(/var VIDEO_INFO = ([.\s\S]*?);/)[1]);
            ctx.body = {
                originalUrl: $('meta[itemprop="url"]').attr('content'),
                playerUrl: `https://v.qq.com/iframe/preview.html?vid=${data.vid}`,
                provider: 'qq',
                title: data.title,
                vid: data.vid,
                swfUrl: `http://static.video.qq.com/TPout.swf?vid=${data.vid}&auto=0`
            };
            yield next();
            return;
        } catch (e) {
            console.log(e);
        }
        yield next();
    }),

    fetchTudouVideo: co.wrap(function*(ctx, next) {
        const { url, types } = ctx.message;
        if (!types.includes('tudou') || !/http:\/\/www.tudou.com\/(.*)?/.test(url)) {
            yield next();
            return;
        }
        try {
            const html = yield util.Http.get(url);
            const data = util.Base.parseObjectString(html.match(/var pageConfig = ([.\s\S]*?);/)[1]);
            ctx.body = {
                originalUrl: url,
                playerUrl: `http://www.tudou.com/programs/view/html5embed.action?code=${data.icode}`,
                provider: 'tudou',
                title: data.kw,
                vid: data.icode,
                swfUrl: `http://www.tudou.com/v/${data.icode}/v.swf`
            };
            yield next();
            return;
        } catch (e) {
            console.log(e);
        }
        yield next();
    }),

    fetchMiaopaiVideo: co.wrap(function*(ctx, next) {
        const { url, types } = ctx.message;
        if (!types.includes('miaopai') || !/http:\/\/www.miaopai.com\/show\/(.*)?.htm/.test(url)) {
            yield next();
            return;
        }

        const videoReg = /(?:<div\s+class="video_flash[.\s\S]*?>)([\s\S.]*?)(?:<\/div>)/;
        const srcReg = /<embed.*?src="(.*?)"/;
        try {
            const html = yield util.Http.get(url);
            const $ = cheerio.load(html);
            const video = html.match(videoReg)[1];
            const src = html.match(srcReg)[1];
            ctx.body = {
                originalUrl: url,
                playerUrl: src,
                provider: 'miaopai',
                title: $('title').text(),
                vid: src.match(/scid=(.*?&)/)[1],
                swfUrl: $('meta[property="og:videosrc"]').attr('content'),
                objectHtml: video
            };
            yield next();
            return;
        } catch (e) {
            console.log(e);
        }
        yield next();
    }),

    fetchSohuVideo: co.wrap(function*(ctx, next) {
        const { url, types } = ctx.message;

        // return BaseApi.get(url).then(res => {
        //     const $ = cheerio.load(res);
        //     const meta = $('meta[property="og:videosrc"]');
        //     const vurl = meta.attr('content');
        //     const id = vurl.match(/\/(\d+)/)[1];
        //     return `<embed type="application/x-shockwave-flash" vid="${id}"`
        //         + ` pluginspage="http://www.macromedia.com/go/getflashplayer" src="${vurl}" width="500" height="300"`
        //         + ' wmode="transparent" play="true" loop="false" menu="false"'
        //         + ' allowscriptaccess="none" allowfullscreen="true">';
        // }).catch(e => {
        //     throw new Error('视频获取错误,请检查是否为搜狐的视频网址');
        // });

        if (!types.includes('sohu') || !/http:\/\/tv.sohu.com\/(.*)?.shtml/.test(url)) {
            yield next();
            return;
        }
        try {
            const html = yield util.Http.get(url);
            const $ = cheerio.load(html);
            const meta = $('meta[property="og:videosrc"]');
            const vurl = meta.attr('content');
            const id = vurl.match(/\/(\d+)/)[1];
            ctx.body = {
                originalUrl: url,
                playerUrl: vurl,
                provider: 'sohu',
                title: $('title').text(),
                vid: id,
                swfUrl: vurl
            };
            yield next();
            return;
        } catch (e) {
            console.log(e);
        }
        yield next();
    }),

    fetchIqiyi: co.wrap(function*(ctx, next) {
        const { url, types } = ctx.message;
        if (!types.includes('iqiyi') || !/http:\/\/www.iqiyi.com\/(.*)?.html/.test(url)) {
            yield next();
            return;
        }

        try {
            const html = yield util.Http.get(url);
            const $ = cheerio.load(html);
            const flashbox = $('#flashbox');
            const videoid = flashbox.data('player-videoid');
            const tvid = flashbox.data('player-tvid');
            const meta = $('meta[property="og:url"]');
            const vurl = meta.attr('content');
            ctx.body = {
                originalUrl: url,
                playerUrl: `http://open.iqiyi.com/developer/player_js/coopPlayerIndex.html?vid=${videoid}&tvId=${tvid}&height=100%&width=100%`,
                provider: 'iqiyi',
                title: $('title').text(),
                vid: videoid,
                swfUrl: '',
                objectHtml: vurl
            };
            yield next();
            return;
        } catch (e) {
            console.log(e);
        }
    }),

    fetchSina: co.wrap(function*(ctx, next) {
        const { url, types } = ctx.message;
        if (!types.includes('iqiyi') || !/http[s]?:\/\/(.*).sina.com.cn\/(.*)?.html/.test(url)) {
            yield next();
            return;
        }

        try {
            const html = yield util.Http.get(url);
            const $ = cheerio.load(html);
            const vid = url.match(/([^/]*).html/)[1];
            ctx.body = {
                originalUrl: url,
                playerUrl: `http://video.sina.com.cn/share/video/${vid}.swf`,
                provider: 'sina',
                title: $('title').text(),
                vid,
                swfUrl: `http://video.sina.com.cn/share/video/${vid}.swf`,
                objectHtml: ''
            };
            yield next();
            return;
        } catch (e) {
            console.log(e);
        }
    }),

    noVideo: function (ctx, next) {
        if (!ctx.body.vid) {
            ctx.body = {
                code: 400,
                msg: '未获取到视频，请检查网页地址'
            };
        }
        next();
    }
};
