const co = require('co');
const ImageModel = require('../model/Image');
const http = require('http');
const https = require('https');
const fileType = require('file-type');

module.exports = {
    // 添加图片和editor重复，本文件存在是为了方便抽离并扩充image相关操作
    addImage: co.wrap(function* (ctx, next) {
        const token = ctx.message.token;
        const localImgUrl = ctx.message.localImgUrl;
        // WARN：这里添加图片尺寸过大会报错：请指定上传文件
        const res = yield ctx.app.WxbApi.uploadImage(token, localImgUrl);
        const file = res.full_url;
        ctx.body = {
            sourceFile: localImgUrl,
            file
        };
        ImageModel.addImage({
            url: localImgUrl,
            file
        });
        yield next();
    }),
    getImageByArticle: co.wrap(function* (ctx, next) {
        // 传入文章ID返回被该文章引用的所有图片
        yield ImageModel.find({
            articleId: ctx.message.articleId
        }).then(res => {
            ctx.body = res;
        });
        yield next();
    }),
    getImagebyPath: co.wrap(function* (ctx, next) {
        ctx.body = yield ImageModel.getImagebyPath(ctx.message.path);
        yield next();
    }),
    getImagebyUrl: co.wrap(function* (ctx, next) {
        ctx.body = yield ImageModel.getImagebyUrl(ctx.message.url);
        yield next();
    }),
    updateItem: co.wrap(function* (ctx, next) {
        ctx.body = yield ImageModel.updateItem(ctx.message.id, ctx.message.attr);
        yield next();
    }),
    getType: co.wrap(function* (ctx, next) {
        const { url } = ctx.message;
        let type = null;
        const hasHttp = url.match(/^http[s]?/);
        if (hasHttp) {
            const hp = {
                http,
                https,
            };
            type = yield new Promise(resolve => {
                hp[hasHttp[0]].get(url, res => {
                    res.once('data', chunk => {
                        res.destroy();
                        resolve(fileType(chunk));
                    });
                });
            });
        } else {
            let typeMatch = url.match(/\.([^/.]*)$/);
            typeMatch = typeMatch ? typeMatch[1] : null;
            type = {
                ext: typeMatch,
                mime: `image/${typeMatch}`
            };
        }
        ctx.body = type;
    })
};
