const co = require('co');
const ArticleModel = require('../model/Article');
const MultiArticle = require('../model/MultiArticle');
const SyncModel = require('../model/Sync');
// 获取一组同步记录的同步总体状态
function _getSyncRecordsStatus(syncRecords) {
    /*
        同步状态：
            0: 等待，
            1：同步中，
            2：同步成功，
            -1：同步失败
            -2: 已取消
        一篇文章的同步状态：
            如果全部平台都为等待中，则该文章状态为等待中
            如果所有平台中有一个平台在同步中或等待中，则该文章状态为同步中
            如果所有平台有一个同步失败，则该文章状态为同步失败
            如果全部平台同步成功，则该文章状态为同步成功
    */
    let status = null; // 默认无同步状态
    if (syncRecords.length) {
        status = 0; // 如果有同步，则默认等待
        const isWait = syncRecords.reduce((result, syncRecord) => result && syncRecord.status === 0, true);
        if (!isWait) {
            // const isDone = syncRecords.reduce(
            //     (result, syncRecord) => result && [2, -1, ].includes(syncRecord.status)
            // );
            syncRecords.forEach(syncRecord => {
                if (status === 1) return;
                if (syncRecord.status === 1 || syncRecord.status === 0) {
                    status = 1;
                    return;
                }
                if (status !== 1 && syncRecord.status === -1) {
                    status = -1;
                    return;
                }
                if (status === 0 && syncRecord.status === 2) {
                    status = 2;
                    return;
                }
                if (status === 0 && syncRecord.status === -2) {
                    status = -2;
                    return;
                }
            });
        }
    }
    return status;
}

module.exports = {
    paseQuery: co.wrap(function* (ctx, next) {
        const query = {
            page: ctx.message.page || 1,
            pagesize: ctx.message.pagesize || 30
        };
        if (ctx.message.platform) {
            query.platforms = ctx.message.platform;
        }
        ctx.query = query;
        yield next();
    }),
    getOneLocalSingelMaterial: co.wrap(function* (ctx, next) {
        const article = yield ArticleModel.findOne(ctx.message.query);
        ctx.body.material = yield SyncModel.find({
            article_id: article._id
        }).then(syncRecords => {
            const { platform_list, createtime, _id } = article;
            const result = {
                key: _id,
                article: Object.assign({ createTime: createtime }, article[platform_list[0]]),
                platformList: platform_list,
                sync: {
                    syncRecords: syncRecords,
                    status: _getSyncRecordsStatus(syncRecords)
                },
                showAction: true
            };
            if (platform_list.length !== 1) {
                result.children = platform_list.map(plantform => {
                    const plantformSyncRecords = syncRecords.filter(
                        syncRecord => syncRecord.account_info.type === plantform
                    );
                    return {
                        key: `${_id}_${plantform}`,
                        article: Object.assign({ createTime: createtime }, article[plantform]),
                        platformList: [plantform],
                        sync: {
                            syncRecords: plantformSyncRecords,
                            status: _getSyncRecordsStatus(plantformSyncRecords)
                        },
                        showAction: false
                    };
                });
            }
            return result;
        });
        yield next();
    }),
    getLocalSingelMaterials: co.wrap(function* (ctx, next) {
        const articles = ctx.body.rows;
        ctx.body.total_rows = ctx.body.total_rows;
        ctx.body.rows = yield Promise.all(articles.map(article => {
            return SyncModel.find({
                article_id: article._id
            }).then(syncRecords => {
                const { platform_list, createtime, _id } = article;
                const result = {
                    key: _id,
                    article: Object.assign({ createTime: createtime }, article[platform_list[0]]),
                    platformList: platform_list,
                    sync: {
                        syncRecords: syncRecords,
                        status: _getSyncRecordsStatus(syncRecords)
                    },
                    showAction: true
                };
                if (platform_list.length !== 1) {
                    result.children = platform_list.map(plantform => {
                        const plantformSyncRecords = syncRecords.filter(
                            syncRecord => syncRecord.account_info.type === plantform
                        );
                        return {
                            key: `${_id}_${plantform}`,
                            article: Object.assign({ createTime: createtime }, article[plantform]),
                            platformList: [plantform],
                            sync: {
                                syncRecords: plantformSyncRecords,
                                status: _getSyncRecordsStatus(plantformSyncRecords)
                            },
                            showAction: false
                        };
                    });
                }
                return result;
            });
        }));
        yield next();
    }),
    getOneLocalMutiMaterial: co.wrap(function* (ctx, next) {
        const article = yield MultiArticle.findOne(ctx.message.query);
        ctx.body.material = yield SyncModel.find({
            article_id: article._id
        }).then(syncRecords => {
            article.syncRecords = syncRecords;
            article.syncStatus = _getSyncRecordsStatus(syncRecords);
            return article;
        });
        yield next();
    }),
    getLocalMutiMaterials: co.wrap(function* (ctx, next) {
        const articles = ctx.body.rows;
        ctx.body.total_rows = ctx.body.total_rows;
        // .filter(item => ctx.message.platform === 'all' || item[ctx.message.platform]);
        ctx.body.articles = yield Promise.all(articles.map(article => {
            return SyncModel.find({
                article_id: article._id
            }).then(syncRecords => {
                article.syncRecords = syncRecords;
                article.syncStatus = _getSyncRecordsStatus(syncRecords);
                return article;
            });
        })).catch(e => console.log(e));

        yield next();
    }),
    getCloudSingelMaterials: co.wrap(function* (ctx, next) {
        const res = yield ctx.app.WxbApi.getSingelMaterials(ctx.message.token, ctx.query);
        ctx.body = res;
        yield next();
    }),
    getCloudMutiMaterials: co.wrap(function* (ctx, next) {
        const res = yield ctx.app.WxbApi.getCloudMutiMaterials(ctx.message.token, ctx.query);
        console.log(res);
        ctx.body = res;
        yield next();
    }),
    delCloudSingelMaterials: co.wrap(function* (ctx, next) {
        const { token, id } = ctx.message;
        const res = yield ctx.app.WxbApi.removeArticleCloud(token, id);
        ctx.body = res;
        yield next();
    }),
    downloadCloudSingelMaterials: co.wrap(function* (ctx, next) {
        const { article } = ctx.message;
        const res = yield ArticleModel.saveArticle({
            cloud_id: article.id
        }, ArticleModel.cloudToLocal(article));
        ctx.body = res;
        yield next();
    }),
    delCloudMutiMaterials: co.wrap(function* (ctx, next) {
        const { token, id } = ctx.message;
        const res = yield ctx.app.WxbApi.delCloudMutiMaterials(token, id);
        ctx.body = res;
        yield next();
    }),
    downloadCloudMutiMaterials: co.wrap(function* (ctx, next) {
        const { material } = ctx.message;
        const res = yield MultiArticle.saveArticle({
            cloud_id: material.id
        }, MultiArticle.cloudToLocal(material));
        ctx.body = res;
        yield next();
    }),
    downloadCloudMutiItem: co.wrap(function* (ctx, next) {
        const { data, platform } = ctx.message;
        const article = {};
        article[platform] = ArticleModel.toLoalItem(data, platform);
        const res = yield ArticleModel.addArticle(article);
        ctx.body = res;
        yield next();
    }),
    uploadSingleMaterial: co.wrap(function* (ctx, next) {
        const { id, token } = ctx.message;
        const article = yield ArticleModel.findOne({ _id: id });
        const res = yield ctx.app.WxbApi.uploadSingelMaterial(token, ArticleModel.toCloud(article));
        article.cloud_id = res._id;
        yield article.save();
        ctx.body = article;
        yield next();
    }),
    uploadMutiMaterial: co.wrap(function* (ctx, next) {
        const { id, token } = ctx.message;
        const article = yield MultiArticle.findOne({ _id: id });
        const res = yield ctx.app.WxbApi.uploadMutiMaterial(token, MultiArticle.toCloud(article));
        article.cloud_id = res._id;
        yield article.save();
        ctx.body = article;
        yield next();
    })
};
