const co = require('co');
const os = require('os');
const AppConfig = require('../model/AppConfig');

module.exports = {
    save: co.wrap(function*(ctx, next) {
        try {
            ctx.app.monitor.save(ctx.message.data);
        } catch (e) {
            ctx.log(`set monitor error::::${e}`);
        }

        yield next();
    }),

    send: co.wrap(function*(ctx, next) {
        try {
            let data = ctx.app.monitor.getData();
            data = data.time.concat(data.count);
            data.forEach(item => {
                item.version = nw.App.manifest.version;
                // item.os = process.platform;
                item.os = os.platform();
                item.release = os.release();
                item.client = ctx.app.clientId;
            });

            if (data.length) {
                const config = yield AppConfig.findOne();
                const res = yield ctx.app.WxbApi.monitorSend(config.token, { data });
                ctx.body = {
                    res,
                    data
                };
            }
        } catch (e) {
            ctx.log(`send monitor error::::${e}`);
        }

        yield next();
    })
};
