const co = require('co');
const MultiArticle = require('../model/MultiArticle');

module.exports = {
    getArticle: co.wrap(function*(ctx, next) {
        const article = yield MultiArticle.findOne(ctx.message.query, ctx.message.options);
        ctx.body = {
            article
        };
        yield next();
    }),
    getArticles: co.wrap(function*(ctx, next) {
        const articles = yield MultiArticle.find(
            ctx.message.query,
            ctx.message.options || { sort: '-createtime' }
        );
        ctx.body = {
            articles
        };
        yield next();
    }),
    getArticleList: co.wrap(function*(ctx, next) {
        const {
            query = {},
            options = { sort: '-createtime' }
        } = ctx.message;
        if (options.page) {
            options.limit = options.page.limit || 10;
            if (options.page.page) {
                options.skip = (options.page.page - 1) * options.limit;
            }
            delete options.page;
        }
        const articleList = yield MultiArticle.find(query, options).catch(e => {
            console.log(e);
        });
        ctx.body = {
            rows: articleList,
            total_rows: yield MultiArticle.count(query)
        };
        yield next();
    }),
    searchByTitle: co.wrap(function* (ctx, next) {
        const articles = yield MultiArticle.find(ctx.message.query);
        ctx.body = {
            articles
        };
        yield next();
    }),
    removeArticle: co.wrap(function* (ctx, next) {
        const deleteRes = MultiArticle.deleteOne({
            _id: ctx.message.data._id
        });
        console.log(deleteRes);
        yield next();
    }),
    saveArticle: co.wrap(function* (ctx, next) {
        const article = yield MultiArticle.saveArticle(ctx.message.query, ctx.message.data);
        ctx.body = {
            article
        };
        yield next();
    })
};
