const co = require('co');

module.exports = {
    list: co.wrap(function*(ctx, next) {
        const { account, page, query } = ctx.message;
        const res = yield ctx.app.PlatformApi.QQ.getAppMsgList(account, {
            page,
            count: 30,
            query
        });
        ctx.body = res;
        yield next();
    }),

    del: co.wrap(function*(ctx, next) {
        const { account, id } = ctx.message;
        const res = yield ctx.app.PlatformApi.QQ.delAppMsg(account, id);
        ctx.body = res;
        yield next();
    }),
    getMaterialById: co.wrap(function*(ctx, next) {
        const { account, id } = ctx.message;
        const materialList = yield ctx.app.PlatformApi.QQ.getMaterialById(account, id);
        ctx.body.materialList = materialList.map(material => ({
            content: material.article,
            cover: {
                type: 'normal',
                url: material.imgsrc.match(/^\/\//) ? `http:${material.imgsrc}` : material.imgsrc
            },
            title: material.title
        }));
        yield next();
    }),
    batchSend: co.wrap(function*(ctx, next) {
        const { account, id, sendTime } = ctx.message;
        const res = yield ctx.app.PlatformApi.QQ.batchSend(account, id, sendTime);
        ctx.body.batchMsg = res;
        yield next();
    })
};
