const co = require('co');
const platform = require('../config/platform');
// const ReportConfig = require('../config/report');
const _ = require('lodash');
const moment = require('moment');
// const ReportData = require('../model/ReportData');
// const Account = require('../model/Account');
// const CacheData = require('../model/CacheData');

function objectPlus(o1, o2) {
    const res = {};
    Object.keys(o1).forEach(key => {
        if (key == 'date') {
            res[key] = o2.date;
        } else {
            res[key] = parseInt(o1[key], 10) + parseInt(o2[key], 10);
        }
    });
    return res;
}

// 给一个数组加上另外一个数组的数据，2个数组中的对象格式一样
function plusDateData(baseList, plusList) {
    plusList.forEach(item => {
        const index = _.findIndex(baseList, (o) => {
            return o.date == item.date;
        });
        if (index > -1) {
            baseList[index] = objectPlus(baseList[index], item);
        } else {
            baseList.push(item);
        }
    });
    return baseList;
}
//
// /**
//  * 根据最近几天的数据计算时间区域
//  * @param lastDays
//  * @returns {'begin_date':beginDate,'end_date':endDate}
//  */
function changeLastDays(lastDays) {
    const endDate = moment().subtract(1, 'days').format('YYYY-MM-DD');
    const beginDate = moment()
        .subtract(lastDays - 1, 'days')
        .format('YYYY-MM-DD');
    return {
        beginDate,
        endDate
    };
}

module.exports = {
    getReportData: co.wrap(function* (ctx, next) {
        const { accountList, lastDays, cache, notFromCache, timeout, tag } = ctx.message;
        const { beginDate, endDate } = changeLastDays(lastDays);
        ctx.platform = accountList[0].type;
        // 获取所有账号的报表数据
        try {
            // 平台特有扩展项，合并计算等在对应平台中处理
            ctx.extend = [];
            const reportList = yield Promise.all(accountList.map((oneAccount) => {
                return ctx.app.sendMessage('/report/getOneAccountReport', {
                    oneAccount,
                    beginDate,
                    endDate,
                    cache,
                    timeout,
                    notFromCache,
                    tag
                }).then(res => {
                    ctx.extend.push(res.body);
                    return res.body.report;
                });
            }));
            const report = [];
            // 累加报表数据
            reportList.forEach((oneReport) => {
                if (oneReport && oneReport.length) {
                    plusDateData(report, oneReport);
                }
            });
            if (!report.length) throw new Error(accountList[0].uid);
            ctx.body = {
                defaultReport: report,
                defaultOverView: report[report.length - 1]
            };
        } catch (e) {
            throw e;
        }
        yield next();
    }),
    // 获取单个账号的报表数据
    getOneAccountReport: co.wrap(function* (ctx, next) {
        const { oneAccount, beginDate, endDate } = ctx.message;
        const platfromConfig = platform[oneAccount.type];
        const platformApi = ctx.app.PlatformApi[platfromConfig.apiName];
        try {
            const report = yield platformApi.getHomeReportData(oneAccount.cookiesMap, {
                begin_date: beginDate,
                end_date: endDate,
                token: oneAccount.token,
                uid: oneAccount.uid,
                accountData: oneAccount,
            });
            console.log(report);
            ctx.body = {
                report
            };
        } catch (e) {
            console.warn(e);
            ctx.log('抓取数据报表失败', e);
            throw new Error(oneAccount.uid);
        }
        yield next();
    }),

    weixinOneAccountUserReportLoader: co.wrap(function* (ctx, next) {
        if (ctx.message.oneAccount.type !== 'weixin' || ctx.message.tag !== 'user') {
            yield next();
            return;
        }
        console.log('weixinOneAccountUserReportLoader');
        const { beginDate, endDate } = changeLastDays(30);
        const { oneAccount } = ctx.message;
        const platfromConfig = platform[oneAccount.type];
        const platformApi = ctx.app.PlatformApi[platfromConfig.apiName];
        try {
            // 99999999: 全部来源
            // 1: 公众号搜索 -
            // 30: 扫码二维码 -
            // 43: 图文右上角菜单 -
            // 57: 图文页内公众号名称 -
            // 17: 名片分享 -
            // 51: 支付后关注
            // 0, 75, 78: 其他合计
            // 用户来源
            const SourceMap = [{
                source: 1,
                name: '公众号搜索',
            }, {
                source: 30,
                name: '扫码二维码',
            }, {
                source: 43,
                name: '图文右上角菜单',
            }, {
                source: 57,
                name: '图文页内公众号名称',
            }, {
                source: 17,
                name: '名片分享',
            }, {
                source: [51, 0, 75, 78],
                name: '其他合计',
            }];
            ctx.body.userOriginReport = [];
            for (const key in SourceMap) {
                const oneSource = SourceMap[key];
                const oneSourceReport = yield platformApi.getFansReport(oneAccount.cookiesMap, {
                    begin_date: beginDate,
                    end_date: endDate,
                    token: oneAccount.token,
                    uid: oneAccount.uid,
                    accountData: oneAccount,
                    source: oneSource.source // 来源
                }).then(res => res.category_list[0].list);
                if (oneSourceReport.length) {
                    ctx.body.userOriginReport.push({
                        name: oneSource.name,
                        value: oneSourceReport.map(item => item.new_user).reduce((pre, cur) => pre + cur)
                    });
                } else {
                    ctx.body.userOriginReport.push({
                        name: oneSource.name,
                        value: 0
                    });
                }
            }

            // 获取消息次数
            ctx.body.messageReport = yield platformApi.getMessageReport(oneAccount.cookiesMap, {
                begin_date: beginDate,
                end_date: endDate,
                token: oneAccount.token,
            });
        } catch (e) {
            console.warn(e);
            ctx.log('抓取数据报表失败', e);
            throw new Error(oneAccount.uid);
        }
        yield next();
    }),
    weixinOneAccountArticleReportLoader: co.wrap(function* (ctx, next) {
        if (ctx.message.oneAccount.type !== 'weixin' || ctx.message.tag !== 'article') {
            yield next();
            return;
        }
        console.warn('weixinOneAccountArticleReportLoader:::in');
        const { oneAccount } = ctx.message;
        const platfromConfig = platform[oneAccount.type];
        const platformApi = ctx.app.PlatformApi[platfromConfig.apiName];
        let articleList = [];
        const lastTime = parseInt(new Date() / 1000, 10) - (86400 * 31);
        while (!articleList.length || articleList[articleList.length - 1].date_time > lastTime) {
            const res = yield platformApi.getSendArticleReport(oneAccount.cookiesMap, {
                begin: articleList.length,
                count: 50,
                token: oneAccount.token,
            });
            console.warn('res', res);
            articleList = articleList.concat(res);
        }
        while (articleList.length && articleList[articleList.length - 1].date_time < lastTime) articleList.pop();
        ctx.body.articleReport = articleList.map(article => {
            const sendNum = article.send_stat.succ;
            const dateTime = article.date_time;
            const children = article.multi_item.map(item => ({
                key: `${article.id}${item.seq}`,
                dateTime,
                date: moment(dateTime * 1000).format('YYYY-MM-DD'),
                title: item.title,
                cover: item.cover,
                likeNum: item.like_num,
                readNum: item.read_num,
                seq: item.seq,
                sendNum: sendNum,
                contentUrl: item.content_url,
                author: item.author,
                openPercent: parseInt(((item.read_num / sendNum) * 10000), 10) / 100
            }));
            return Object.assign({}, children[0], {
                children,
                key: article.id
            });
        });
        console.warn('ctx.body.articleReport:::::', ctx.body.articleReport);
    }),
    weixinReportLoader: co.wrap(function* (ctx, next) {
        if (ctx.platform !== 'weixin') {
            yield next();
            return;
        }
        const { defaultReport } = ctx.body;
        const dateTag = {
            day: 3,
            week: 10,
            month: 32
        };
        const trendKeys = ['addFollow', 'newFollow', 'totalFollow', 'unFollow'];
        if (defaultReport.length >= 32) {
            const userTrend = {};
            const yesterdayData = defaultReport.slice(-2)[0];
            Object.keys(dateTag).forEach(tag => {
                const oldDate = defaultReport.slice(-dateTag[tag])[0];
                trendKeys.forEach(trendKey => {
                    userTrend[trendKey] = userTrend[trendKey] || {};
                    if (oldDate[trendKey]) {
                        const changeNumber = yesterdayData[trendKey] - oldDate[trendKey];
                        const trend = changeNumber / oldDate[trendKey];
                        userTrend[trendKey][tag] = Number(trend * 100).toFixed(1);
                    } else {
                        userTrend[trendKey][tag] = null;
                    }
                });
            });
            ctx.body.userTrend = userTrend;
            ctx.body.yesterdayUserOverView = defaultReport[defaultReport.length - 2];
        }
        console.debug(ctx.extend);
        // 处理用户来源
        let extend = {};
        if (ctx.extend.length === 1) {
            extend = ctx.extend[0];
        } else {
            console.warn('请处理多账号中微信用户增加来源逻辑');
        }
        const { userOriginReport, messageReport, articleReport } = extend;

        if (userOriginReport && userOriginReport.length) ctx.body.userOriginReport = userOriginReport;
        if (messageReport && messageReport.length) ctx.body.messageReport = messageReport;
        if (articleReport && articleReport.length) {
            const todayDateFlag = moment().format('YYYY-MM-DD');
            const yesterdayDateFlag = moment().subtract(1, 'days').format('YYYY-MM-DD');
            articleReport.forEach(article => {
                if (article.date === todayDateFlag) {
                    ctx.body.todayArticleOverView = Object.assign({}, article, {
                        openPercent: `${article.openPercent}%`
                    });
                }
                if (article.date === yesterdayDateFlag) {
                    ctx.body.yesterdayArticleOverView = Object.assign({}, article, {
                        openPercent: `${article.openPercent}%`
                    });
                }
            });
            ctx.body.articleReport = articleReport;
        }
        yield next();
    })
};
