const co = require('co');
const AppConfig = require('../model/AppConfig');
const Ctrl = {
    start: co.wrap(function* (ctx, next) {
        setTimeout(() => {
            AppConfig.findOne().then(function (res) {
                if (res && res.token) {
                    ctx.app.SogouSpider.start(res.token, ctx.message.startType);
                } else {
                    console.warn('未登录');
                }
            });
        });
    }),
    getStatus: co.wrap(function* (ctx, next) {
        const data = yield ctx.app.SogouSpider.getStatus();
        ctx.body = data;
        yield next();
    }),
    stop: co.wrap(function* (ctx, next) {
        return ctx.app.SogouSpider.stopAction();
    }),
};

module.exports = Ctrl;
