const co = require('co');
const moment = require('moment');
const AppConfig = require('../model/AppConfig');
moment.locale('zh-cn');
const CacheData = require('../model/CacheData');
const needle = require('needle');
needle.defaults({
    open_timeout: 1000 * 60 * 20,
    user_agent: 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) '
        + 'AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36'
});

module.exports = {
    getArticleCategories: co.wrap(function*(ctx, next) {
        const categories = yield ctx.app.WxbApi.getPublcArticleCategories();
        const catesList = [{ groupName: '综合榜', groupId: 0 }];
        Object.keys(categories.data).forEach(key => {
            catesList.push({
                groupName: categories.data[key],
                groupId: key,
            });
        });
        ctx.body = {
            catesList
        };
        yield next();
    }),
    getArticleTop: co.wrap(function*(ctx, next) {
        const { token, userInput, date, cate, page, video, order } = ctx.message;
        // CacheData.findOne({cacheId: JSON.string(ctx.message,)}) ;
        const ArticleTop = yield ctx.app.WxbApi.getPublickArticleTop(page, {
            category: cate || 0,
            order: order || '',
            date: date || '',
            q: userInput || '',
            content_type: video || '',
            token: token,
        });
        ctx.body.ArticleTopNum = ArticleTop.totalCount;
        ctx.body.ArticleTop = ArticleTop.data.map(item => {
            return item;
        });
        // save cache.save({cacheId: JSON.string(ctx.message, ctx.body, timeout: new Date() + 24*60*60));
        // CacheData.findOne({cacheId: JSON.string(ctx.message,)}) ;
        yield next();
    }),
    getNewPublicArticleTop: co.wrap(function*(ctx, next) {
        const { token, userInput, type, cate, page, video, order } = ctx.message;
        const ArticleTop = yield ctx.app.WxbApi.getNewPublicArticleTop(page, {
            category: cate || 0,
            order: order || '',
            type: type || 0,
            q: userInput || '',
            content_type: video || '',
            token: token,
            pageSize: 20,
        });
        console.log(ArticleTop);
        ctx.body.ArticleTopNum = ArticleTop.pager.numRecords;
        ctx.body.ArticleTop = ArticleTop.data.map(item => {
            item.read_num = item.read_num && item.read_num != '' ? item.read_num : '-';
            item.like_num = item.like_num && item.like_num != '' ? item.like_num : '-';
            item.content_type = parseInt(item.content_type, 10);
            item.is_original = parseInt(item.is_original, 10);
            item.create_time = moment(item.push_time * 1000).format('YYYY-MM-DD HH:mm');
            return item;
        });
        yield next();
    }),
    getArticleHot: co.wrap(function*(ctx, next) {
        const { token, userInput, date, cate, page, video, order } = ctx.message;
        const ArticleHot = yield ctx.app.WxbApi.getPublickArticleHot(page, {
            category: cate || 0,
            order: order || '',
            date: date || '',
            q: userInput || '',
            content_type: video || '',
            token: token,
        });
        ctx.body = {
            ArticleHotNum: ArticleHot.totalCount,
            ArticleHot: ArticleHot.data.map(item => ({
                _id: item._id,
                article_url: item.article_url,
                content_type: parseInt(item.content_type, 10),
                cover: item.cover,
                id: item.id,
                is_collect: item.is_collect,
                is_original: parseInt(item.is_original, 10),
                like_num: item.like_num && item.like_num != '' ? item.like_num : '-',
                push_date: moment(item.push_time * 1000).format('YYYY-MM-DD hh:mm'),
                push_time: item.push_time,
                read_percent: item.read_percent ? item.read_percent * 100 : '',
                title: item.title,
                weixin_name: item.weixin_name,
                wx_origin_id: item.wx_origin_id,
            })),
        };
        yield next();
    }),
    searchArticle: co.wrap(function*(ctx, next) {
        const SearchResult = yield ctx.app.WxbApi.publicArticleSearch('sousuo', {
            page: 1,
            pageSize: 20,
        });
        ctx.body = {
            SearchResult
        };
        yield next();
    }),
    searchgzhAccount: co.wrap(function*(ctx, next) {
        const FollowAccount = yield ctx.app.WxbApi.getMyFollowAccount(ctx.message.token);
        console.log(FollowAccount);
        const userInput = ctx.message.userInput;
        const page = ctx.message.page;
        const SearchResult = yield ctx.app.WxbApi.searchWeiXinAccount(userInput, {
            page,
            pageSize: 12,
        });
        if (FollowAccount) {
            ctx.body = {
                ResultNum: SearchResult.totalCount,
                ResultList: SearchResult.data.map((item, index) => ({
                    key: index,
                    id: item.wx_origin_id,
                    name: item.name,
                    src: item.avatar || 'http://s.weituibao.com/beta/pc/img/default-avatar.jpg',
                    subTitle: item.desc,
                    status: FollowAccount.data.map(myfollow => myfollow.wx_origin_id).includes(item.wx_origin_id)
                })),
            };
        }
        yield next();
    }),
    searchgzhAccountByUrl: co.wrap(function*(ctx, next) {
        const FollowAccount = yield ctx.app.WxbApi.getMyFollowAccount(ctx.message.token);
        const SearchResult = yield ctx.app.WxbApi.searchWeiXinAccountByUrl({
            url: ctx.message.userInput,
            token: ctx.message.token
        });
        ctx.body = {
            ResultNum: 1,
            ResultList: [{
                key: 0,
                id: SearchResult.gzh_info.wx_origin_id,
                name: SearchResult.gzh_info.name,
                src: SearchResult.gzh_info.avatar || 'http://s.weituibao.com/beta/pc/img/default-avatar.jpg',
                subTitle: SearchResult.gzh_info.desc,
                status: FollowAccount.data.map(myfollow => myfollow.id).includes(SearchResult.gzh_info.id)
            }],
        };
        yield next();
    }),
    followgzhAccount: co.wrap(function*(ctx, next) {
        console.warn(ctx.message);
        const followResult = yield ctx.app.WxbApi.addWeiXinFollow(
            ctx.message.token,
            ctx.message.id
        );
        console.warn(followResult);
        ctx.body = {
            message: followResult.message
        };
        yield next();
    }),
    MyfollowArticles: co.wrap(function*(ctx, next) {
        const { token, page, account_id, group_id, pageSize } = ctx.message;
        const arg = {
            page,
            group_id,
            days: ctx.message.days,
            kw: ctx.message.kw,
            order: ctx.message.order,
            is_first: ctx.message.is_first,
            account_id,
            pageSize
        };
        Object.keys(arg).forEach(key => {
            if (!arg[key]) delete arg[key];
        });
        ctx.body = yield ctx.app.WxbApi.getMyFollowArticles(token, arg).then(res => {
            console.warn(res);
            return ({
                pager: res.pager,
                followArticles: res.data.map(article => Object.assign(article, {
                    article_title: article.article_title || '-',
                    article_url: article.article_url || '',
                    cover: article.cover || '',
                    gzh_name: article.gzh_name == 0 ? 0 : (article.gzh_name || '- -'),
                    read_num: article.read_num == 0 ? 0 : (article.read_num || '- -'),
                    like_num: article.like_num == 0 ? 0 : (article.like_num || '- -'),
                    content_type: parseInt(article.content_type, 10),
                    is_original: parseInt(article.is_original, 10),
                    publish_time: moment(article.push_time * 1000).format('YYYY-MM-DD HH:mm'),
                }))
            });
        });
        yield next();
    }),
    getMyFollowAccount: co.wrap(function*(ctx, next) {
        const FollowAccount = yield ctx.app.WxbApi.getMyFollowAccount(ctx.message.token);
        console.log(FollowAccount);
        ctx.body = {
            FollowAccount
        };
        yield next();
    }),
    getMyFollowAccountGroup: co.wrap(function*(ctx, next) {
        const token = ctx.message.token;
        const _FollowAccountGroup = yield ctx.app.WxbApi.getMyFollowAccountGroup(token);
        console.log(_FollowAccountGroup);
        ctx.body.FollowAccountGroup = _FollowAccountGroup.data.map(item => ({
            groupName: item.group_name,
            groupId: item.group_id,
            gzhNum: item.gzh_num,
            accountList: item.accounts.map(account => ({
                uid: account.id || '',
                avatar: account.avatar || '',
                username: account.name || '',
                desc: account.desc || '',
                is_verify: account.is_verify || '',
                update_time: account.update_time || '',
                weixin_id: account.weixin_id || '',
                wx_origin_id: account.wx_origin_id || '',
                // 更新公众号用
                name: account.name || '',
                wx_alias: account.wx_alias || '',
            })),
        }));
        let accountList = [];
        _FollowAccountGroup.data.forEach(item => {
            accountList = accountList.concat(item.accounts.map(account => {
                item.groupName = account.username || '';
                item.groupId = account.weixin_id || '';
                item.avatar = account.avatar || '';
                return account;
            }));
        });
        ctx.body.FollowAccountGroupList = accountList;
        yield next();
    }),
    getUserKeywords: co.wrap(function*(ctx, next) {
        const UserKeywords = yield ctx.app.WxbApi.keywordsFollowList(ctx.message.token);
        ctx.body.UserKeywords = UserKeywords.data.map(item => ({
            groupName: item.keyword,
            groupId: item.id,
            createTime: item.create_time,
            userId: item.user_id,
            pos: item.pos,
        }));
        yield next();
    }),
    addKeywords: co.wrap(function*(ctx, next) {
        const userInput = ctx.message.userInput;
        const token = ctx.message.token;
        const addKeywords = yield ctx.app.WxbApi.addKeywordsFollow(token, userInput);
        ctx.body = {
            addKeywords
        };
        yield next();
    }),
    updateKeyword: co.wrap(function*(ctx, next) {
        const userInput = ctx.message.userInput;
        const token = ctx.message.token;
        const id = ctx.message.id;
        const updateKeyword = yield ctx.app.WxbApi.updateKeywordsFollow(
            token, id, userInput);
        ctx.body = {
            updateKeyword
        };
        yield next();
    }),
    deleteKeyword: co.wrap(function*(ctx, next) {
        const token = ctx.message.token;
        const id = ctx.message.id;
        const deleteKeyword = yield ctx.app.WxbApi.delKeywordsFollow(token, id);
        ctx.body = {
            deleteKeyword
        };
        yield next();
    }),
    keywordsFollowArticles: co.wrap(function*(ctx, next) {
        const { token, q, order, contentType, days, page, q1 } = ctx.message;
        const keywordArticles = yield ctx.app.WxbApi.keywordsFollowArticles(
            token, q, page, order, contentType, days, q1);
        ctx.body = {
            keywordArticles: keywordArticles.data.map(item => {
                item.read = item.read && item.read != '' ? item.read : '-';
                item.like = item.like && item.like != '' ? item.like : '-';
                item.push_date = moment(item.push_time * 1000).format('YYYY-MM-DD HH:mm');
                item.content_type = parseInt(item.content_type, 10);
                item.is_original = parseInt(item.is_original, 10);
                return item;
            })
        };
        yield next();
    }),
    downloadWeiXinArticle: co.wrap(function*(ctx, next) {
        const { url } = ctx.message;
        const info = yield ctx.app.sendMessage({
            name: '/article/fetch',
            url
        }).then(res => res.body);
        ctx.body = yield ctx.app.sendMessage({
            name: '/article/addArticle',
            data: {
                weixin: {
                    cover: {
                        type: 'normal',
                        url: info.headImg
                    },
                    title: info.title,
                    content: info.content
                }
            }
        }).then(res => res.body.article);
        yield next();
    }),
    removeWeiXinFollow: co.wrap(function*(ctx, next) {
        const { token, ids } = ctx.message;
        const wxRes = yield ctx.app.WxbApi.removeWeiXinFollow(token, ids);
        ctx.body = wxRes;
        yield next();
    }),
    newWeiXinFollowGroup: co.wrap(function*(ctx, next) {
        const { token, groupName } = ctx.message;
        const wxRes = yield ctx.app.WxbApi.addWeiXinFollowGroup(token, groupName);
        ctx.body = {
            groupName,
            groupId: wxRes.group_id,
            gzhNum: 0,
            accountList: []
        };
        yield next();
    }),
    updateWeiXinFollowGroupName: co.wrap(function*(ctx, next) {
        const { token, groupName, id } = ctx.message;
        const wxRes = yield ctx.app.WxbApi.updateWeiXinFollowGroupName(token, id, groupName);
        ctx.body = wxRes;
        yield next();
    }),
    delWeiXinFollowGroupName: co.wrap(function*(ctx, next) {
        const { token, id } = ctx.message;
        const wxRes = yield ctx.app.WxbApi.delWeiXinFollowGroupName(token, id);
        ctx.body = wxRes;
        yield next();
    }),
    moveWeiXinFollowToGroup: co.wrap(function*(ctx, next) {
        const { token, fromIds, toId } = ctx.message;
        const wxRes = yield ctx.app.WxbApi.moveWeiXinFollowToGroup(token, toId, fromIds);
        ctx.body = wxRes;
        yield next();
    }),
    getArticleDetail: co.wrap(function*(ctx, next) {
        const { token, id } = ctx.message;
        const res = yield ctx.app.WxbApi.getArticleDetail(token, id);
        console.log(res);
        ctx.body = res;
        yield next();
    }),
    // 获取推荐公众号列表
    getRecommendAccount: co.wrap(function*(ctx, next) {
        const { category, token, page } = ctx.message;
        const FollowAccount = yield ctx.app.WxbApi.getMyFollowAccount(token);
        const recommendList = yield ctx.app.WxbApi.getRecommendAccountList(category, {
            page,
            pageSize: 12
        });
        if (FollowAccount) {
            ctx.body = {
                ResultNum: recommendList.pager,
                recommendList: recommendList.data.map((item, index) => ({
                    key: index,
                    id: item.wx_origin_id,
                    name: item.name,
                    src: item.avatar || 'http://s.weituibao.com/beta/pc/img/default-avatar.jpg',
                    subTitle: item.desc,
                    status: FollowAccount.data.map(myfollow => myfollow.wx_origin_id).includes(item.wx_origin_id)
                })),
            };
        }
        yield next();
    }),
    // 启动自动抓取微信文章
    startWeiXinSpider: co.wrap(function*(ctx, next) {
        const config = yield AppConfig.findOne();
        if (!config.token) {
            ctx.body = {
                success: false,
                msg: '没有微小宝账号'
            };
            yield next();
            return;
        }
        const followGroup = yield ctx.app.WxbApi.getMyFollowAccountGroup(config.token);
        let accountList = [];
        followGroup.data.forEach(item => {
            accountList = accountList.concat(item.accounts.map(account => {
                return account;
            }));
        });
        const secretUrl = yield ctx.app.WeiXinAutoSpider.init();
        const cacheTime = 3 * 3600 * 1000; // 控制超过3小时才抓取一次账号
        if (true) {
            // 过滤出需要执行抓取的账号
            const cacheAccounts = yield CacheData.find({
                type: 'spider'
            });
            if (cacheAccounts) {
                const ids = [];
                cacheAccounts.forEach(item => {
                    if ((new Date() - cacheTime - item.createtime) < 0) {
                        ids.push(item.cacheId.replace('spider_', ''));
                    }
                });
                accountList = accountList.filter(item => {
                    return !ids.includes(item.wx_origin_id);
                });
            }
            ctx.app.WeiXinAutoSpider.on('oneSuccess', (account) => {
                const cacheId = `spider_${account.wx_origin_id}`;
                CacheData.findOneAndUpdate({
                    cacheId
                }, {
                    cacheId,
                    data: {},
                    type: 'spider',
                    createtime: new Date(),
                    timeout: cacheTime
                }, { upsert: true });
            });
            console.log('需要抓取的账号列表:', accountList);
            ctx.app.WeiXinAutoSpider.start(accountList);
            ctx.body.success = true;
            config.lastWeiXinSpiderTime = new Date();
            yield config.save();
        } else {
            ctx.body = {
                success: false,
                msg: '服务器资源缺乏'
            };
            console.log(ctx.body);
        }
        yield next();
    })
};
