const co = require('co');
const moment = require('moment');
// const { getSyncRecordsStatus } = require('../modules/util/task');

/**
 * task
 * {
 *      id: String,
 *      type: String,
 *      title: '',
 *      updateTime: Number,
 *      data: [], // 任务信息
 *      done,
 *      total,
 *      state,
 *      message
 * }
 */

// 最后改一次

module.exports = {
    add: co.wrap(function*(ctx, next) {
        const { task } = ctx.message;
        const { taskOS } = ctx.app;
        if (!taskOS.record) taskOS.record = [];
        taskOS.record.unshift(task);
        ctx.body.message = '添加任务成功';
        yield next();
    }),
    // 更新任务状态
    update: co.wrap(function*(ctx, next) {
        const { task } = ctx.message;
        const { taskOS } = ctx.app;
        taskOS.record = taskOS.record.map(_task => {
            if (_task.id === task.id) return Object.assign({}, _task, task);
            return _task;
        });
        console.warn(taskOS.record);
        ctx.body.message = '更新任务状态成功';
        yield next();
    }),
    // 更新任务中某条记录的状态
    updateTaskRecord: co.wrap(function*(ctx, next) {
        const { taskId, record } = ctx.message;
        const { taskOS } = ctx.app;
        const currentTask = taskOS.record.filter(_task => _task.id === taskId)[0];
        currentTask.data = currentTask.data.map(_record => {
            if (record.uid === _record.uid) return record;
            return _record;
        });
        ctx.message.currentTask = currentTask;
        yield next();
    }),
    updateSougouTask: co.wrap(function*(ctx, next) {
        const { currentTask } = ctx.message;
        const { taskOS } = ctx.app;
        if (currentTask.type !== 'sougou') {
            yield next();
            return;
        }
        currentTask.complete = [];
        currentTask.notFound = [];
        currentTask.failure = [];
        // 开始处理当前任务信息
        currentTask.wait = 0;
        currentTask.data.forEach(record => {
            if (record.state) {
                currentTask[record.state].push(record);
                return;
            }
            currentTask.wait ++;
        });
        currentTask.notFoundLength = currentTask.notFound.length;
        // currentTask.done = currentTask.complete.length + currentTask.notFoundLength;
        currentTask.fail = currentTask.failure.length;
        if (currentTask.wait === 0) {
            if (currentTask.fail === 0) {
                currentTask.state = 'success';
            } else {
                currentTask.state = 'error';
            }
            currentTask.title = `成功:${currentTask.complete.length},未收录:${currentTask.notFoundLength},失败:${currentTask.fail}`;
            currentTask.message = `更新完成：${moment().format('MM-DD HH:mm')}`;
        }
        taskOS.record = taskOS.record.map(_task => {
            if (_task.id === currentTask.id) return currentTask;
            return _task;
        });
        ctx.body.currentTask = currentTask;
        ctx.body.message = '更新任务状态成功';
        yield next();
    }),
    // 获取任务通知
    getTaskNotice: co.wrap(function*(ctx, next) {
        /**
         * TODO: 获取任务通知列表
         */
        const { taskOS } = ctx.app;
        if (!taskOS.record) taskOS.record = [];
        ctx.body.taskList = taskOS.record;
        yield next();
    }),
    // // 执行任务
    // do: co.wrap(function*(ctx, next) {
    //     const { taskOS } = ctx.app;
    //     const { type } = ctx.message;
    //     if (!taskOS[type].length) {
    //         yield next();
    //         return;
    //     }
    //     ctx.message.currentTask = taskOS[type].shift();
    //     yield next();
    // }),
    // // 执行同步文章任务
    // doSyncTask: co.wrap(function*(ctx, next) {
    //     const { currentTask, type } = ctx.message;
    //     if (currentTask.type !== 'syncArticle' && currentTask.type !== 'syncMutiArticle') {
    //         yield next();
    //         return;
    //     }
    //     yield ctx.app.sendMessage({
    //         name: '/sync/oneAccount',
    //         syncRecordId: currentTask.data._id
    //     });
    //     ctx.app.sendMessage({ name: '/task/do', type: type });
    //     yield next();
    // }),
};
