const co = require('co');

const Temp = require('../model/temp');

module.exports = {
    save: co.wrap(function*(ctx, next) {
        Temp.save({
            type: ctx.message.type,
            data: ctx.message.data
        });

        yield next();
    }),

    get: co.wrap(function*(ctx, next) {
        const res = yield Temp.get({ type: ctx.message.type });
        ctx.body = res;

        yield next();
    }),

    delete: co.wrap(function*(ctx, next) {
        yield Temp.delete({ type: ctx.message.type });

        yield next();
    })
};
