const co = require('co');

module.exports = {
    getTemplate: co.wrap(function* (ctx, next) {
        const { token, uid, type } = ctx.message;
        const res = yield ctx.app.WxbApi.getTemplate(token, uid, type);
        ctx.body = res;
        yield next();
    }),
    setTemplate: co.wrap(function* (ctx, next) {
        const { token, uid, type, template } = ctx.message;
        const res = yield ctx.app.WxbApi.setTemplate(token, uid, type, template);
        ctx.body = res;
        yield next();
    })
};
