const co = require('co');

module.exports = {
    getSendTimerAcountList: co.wrap(function* (ctx, next) {
        // rawId 公众号原始ID
        const res = yield ctx.app.WxbApi.getSendTimerAcountList(ctx.message.token);
        ctx.body = {
            accountList: res.data
        };
        yield next();
    }),
    getTimingGroupList: co.wrap(function* (ctx, next) {
        // rawId 公众号原始ID
        const res = yield ctx.app.WxbApi.getSendTimerList(ctx.message.token, ctx.message.args);
        if (res.errcode) {
            throw new Error(res.msg);
        }
        ctx.body = {
            timingGroupList: res.data.map(item => Object.assign(item, {
                article: {
                    title: item.title,
                    media_id: item.media_id
                },
                account: {
                    src: item.head_img,
                    name: item.wx_name
                },
                key: item.id
            })),
            totalCount: res.totalCount
        };
        yield next();
    }),
    addSendTimer: co.wrap(function* (ctx, next) {
        /*
            请求地址：/news/setsendtimer
            请求方法：POST
            参数：
                - auth_id:授权账号ID
                mobile:用户接收通知手机号，可不传
                - media_id:素材ID
                msg_type:消息类型(text文本、image图片、voice语音、mpnews图文消息<默认>（点击跳转到图文消息页面）、news图文消息（点击跳转到外链）)
                total_count:文章总数
                title:首篇文章标题
                desc: 首篇摘要
                thumb_media_id:封面media_id
                - send_time: 计划发送时间
                source: 'pc'
        */
        const res = yield ctx.app.WxbApi.addSendTimer(
            ctx.message.token,
            ctx.message.authId,
            ctx.message.mediaId,
            ctx.message.sendTime,
            ctx.message.args
        );
        ctx.body = {
            res
        };
        yield next();
    }),
    updateSendTimer: co.wrap(function* (ctx, next) {
        // id Timer的id,其余跟增加一样
        const res = yield ctx.app.WxbApi.updateSendTimer(
            ctx.message.token,
            ctx.message.id,
            ctx.message.args
        );
        ctx.body = {
            res
        };
        yield next();
    }),
    removeSendTimer: co.wrap(function* (ctx, next) {
        // id Timer的id
        const res = yield ctx.app.WxbApi.removeSendTimer(ctx.message.token, ctx.message.id);
        ctx.body = {
            res
        };
        yield next();
    }),
    getWeiXinMaterial: co.wrap(function* (ctx, next) {
        // id Timer的id
        const res = yield ctx.app.WxbApi.getWeiXinMaterial(
            ctx.message.token,
            ctx.message.authId,
            ctx.message.args
        );
        ctx.body = {
            materialList: res.data.item.map(material => ({
                update_time: material.update_time,
                media_id: material.media_id,
                articles: material.content.news_item
            })),
            total: res.data.total_count
        };
        yield next();
    }),
};
