const co = require('co');

module.exports = {
    list: co.wrap(function*(ctx, next) {
        const { account, page, query } = ctx.message;
        try {
            const res = yield ctx.app.PlatformApi.WeiXin.getAppMsgList(account, {
                page,
                count: 30,
                query
            });
            ctx.body = res;
        } catch (e) {
            ctx.log('抓取微信素材列表失败', e);
            throw new Error('抓取微信素材列表失败');
        }
        yield next();
    }),

    del: co.wrap(function*(ctx, next) {
        const { account, id } = ctx.message;
        const res = yield ctx.app.PlatformApi.WeiXin.delAppMsg(account, id);
        ctx.body = res;
        yield next();
    }),

    getPreviewUrl: co.wrap(function*(ctx, next) {
        const { account, id, index } = ctx.message;
        console.log(account, id, index);
        const res = yield ctx.app.PlatformApi.WeiXin.getPreviewUrl(account, id, index);
        ctx.body = res;
        yield next();
    }),

    getOneWeiXinMaterial: co.wrap(function*(ctx, next) {
        const res = yield ctx.app.PlatformApi.WeiXin.fetchWeiXinArticle(ctx.body.url);
        console.log(res);
        ctx.body = {
            content: res.content,
            cover: {
                type: 'normal',
                url: res.headImg
            },
            title: res.title,
            author: res.author,
            sourceurl: res.source_url,
            digest: res.desc
        };
        yield next();
    }),
    getMultiWeiXinMaterial: co.wrap(function*(ctx, next) {
        const { account, id, number } = ctx.message;
        const materialList = [];
        for (let i = 1; i <= number; i++) {
            const urlObj = yield ctx.app.PlatformApi.WeiXin.getPreviewUrl(account, id, i);
            const res = yield ctx.app.PlatformApi.WeiXin.fetchWeiXinArticle(urlObj.url);
            materialList.push({
                content: res.content,
                cover: {
                    type: 'normal',
                    url: res.headImg
                },
                title: res.title,
                author: res.author,
                sourceurl: res.source_url,
                digest: res.desc
            });
        }
        ctx.body.materialList = materialList;
        yield next();
    }),
    sendBatchMaterial: co.wrap(function*(ctx, next) {
        const { user, token, id, operation_seq } = ctx.message;
        const resFinish = yield ctx.app.PlatformApi.WeiXin.finishBatchSend(
            user,
            token,
            id,
            operation_seq
        );
        console.warn('resFinish:::::::', resFinish);
        if (resFinish.base_resp.err_msg === 'ok') {
            ctx.body.status = true;
            ctx.body.errMsg = resFinish.base_resp.err_msg;
        } else {
            ctx.body.status = false;
            ctx.body.errMsg = resFinish.base_resp.err_msg;
        }
        yield next();
        return;
    }),
};
