'use strict';

const Document = require('camo').Document;

function _changeKey(data, from, to) {
    try {
        if (data) {
            Object.keys(data).forEach(k => {
                const _key = k.replace(from, to);
                if (_key !== k) {
                    data[_key] = data[k];
                    delete data[k];
                }
            });
        }
    } catch (e) {
        console.log(e);
    }
}

class Account extends Document {
    constructor() {
        super();
        this.schema({
            account: {
                type: String,
                required: false
            },
            avatar: {
                type: String,
                required: false
            },
            cookies: {
                type: Object
            },
            cookiesMap: {
                type: Object,
                required: false
            },
            hasMsgcopyright: {
                type: Boolean,
                required: false
            },
            loginTime: {
                type: Date,
                required: false
            },
            order: {
                type: Number,
                required: false
            },
            password: {
                type: String,
                required: false
            },
            token: {
                type: String,
                required: false
            },
            type: {
                type: String,
                required: false
            },
            uid: {
                type: String,
                required: true
            },
            unid: {
                type: String,
                required: false
            },
            cloudId: {
                type: String,
                required: false
            },
            username: {
                type: String,
                required: false
            },
            createTime: {
                type: Date,
                required: false
            },
            authInfo: {
                type: Object,
                required: false
            },
            // 百家号
            userInfo: {
                type: Object,
                required: false
            },
            // 微信
            ticket: {
                type: String,
                required: false
            },
            ticket_id: {
                type: String,
                required: false
            },
            is_verify: {
                type: Boolean,
                required: false
            }
        });
    }

    // 用于移库，可以同时对数据字段进行整理
    static addAccount(data) {
        data.loginTime = new Date(data.loginTime);
        if (String(data.loginTime) === 'Invalid Date') {
            data.loginTime = new Date();
        }
        return this.findOne({ uid: data.uid }).then((l) => {
            if (l) {
                return null;
            }
            const account = this.create(data);
            account.save().catch(e => {
                return e;
            });
            _changeKey(data.cookies, /_/g, '.');
            _changeKey(data.cookiesMap, /\$_\$/g, '.');
            return data;
        });
    }

    static getAccount(accountId) {
        return this.findOne({
            _id: accountId
        }).then(res => {
            if (res) {
                _changeKey(res.cookies, /_/g, '.');
                _changeKey(data.cookiesMap, /\$_\$/g, '.');
            }
            return res;
        });
    }

    static findOneAccountByQuery(query) {
        console.debug('[_rainey:-:findOneAccountByQuery:::::]', query);
        return this.findOne(query).then(res => {
            if (res) {
                _changeKey(res.cookies, /_/g, '.');
                _changeKey(res.cookiesMap, /\$_\$/g, '.');
            }
            return res;
        });
    }

    // 读取前转换cookies的key
    static getAccountList(type = 'all') {
        let filter = {};
        if (type !== 'all') {
            filter = { type };
        }
        return this.find(filter, { sort: '-createTime' }).then(res => {
            res.forEach(item => {
                if (item) {
                    _changeKey(item.cookies, /_/g, '.');
                    _changeKey(item.cookiesMap, /\$_\$/g, '.');
                }
            });
            return res;
        });
    }

    static updateAccount(uid, data) {
        delete data._schema;
        delete data._id;
        Object.keys(data).forEach(key => {
            if (data[key] === undefined) {
                delete data[key];
            }
        });
        if (data) _changeKey(data.cookies, /\./g, '_');
        _changeKey(data.cookiesMap, /\./g, '$_$');
        return this.findOneAndUpdate({
            uid
        }, data, {
            upsert: true
        }).then(res => {
            _changeKey(res.cookies, /_/g, '.');
            _changeKey(res.cookiesMap, /\$_\$/g, '.');
            return res;
        });
    }

    // 保存前转换cookies的key
    preSave() {
        _changeKey(this.cookies, /\./g, '_');
        _changeKey(this.cookiesMap, /\./g, '$_$');
    }
}

module.exports = Account;
