'use strict';

const Document = require('camo').Document;

class CollectionStatus extends Document {
    constructor() {
        super();
        this.schema({
            id: {
                type: String,
                unique: true,
                required: true
            },
            typeId: {
                type: String,
                required: true
            },
            type: {
                type: String,
                required: true
            },
            date: {
                type: Date,
                default: Date.now,
                required: true
            },
            reportType: {
                type: String,
                required: true,
                choices: ['system', 'fans']
            },
            status: {
                type: Number,
                default: 0,
                choices: [0, 1, 2], // 0:未提交, 1:提交成功, 2:提交中
                required: true
            }
        });
    }
}

module.exports = CollectionStatus;
