'use strict';

const Document = require('camo').Document;

class Compose extends Document {
    constructor() {
        super();
        this.schema({
            addtime: {
                type: Date,
                required: false
            },
            // 在列表中的位置
            no: {
                type: Number,
                required: false
            },
            // 0-本地图文  1-外部文章链接
            type: {
                type: String,
                required: false
            },
            cover: {
                type: String,
                required: false
            },
            title: {
                type: String,
                required: false
            },
            source: {
                type: Object,
                required: false
            },
        });
    }

    static addArticle(source) {
        return this.find({}, {
            sort: 'no'
        }).then(articleList => {
            const data = Object.assign({}, source);
            delete data._id;
            data.addtime = new Date();
            if (articleList.length === 8) throw new Error('图文合成器文章数量不能超过8篇！');
            data.no = articleList.length + 1;
            const article = this.create(data);
            return article.save();
        });
    }

    static updateArticle(query, art) {
        const article = Object.assign({}, art);
        console.log(article);
        article.addtime = article.addtime || new Date();
        // 删除_schema否则会报错
        delete article._schema;
        // 过滤undefined，否则也会报错
        Object.keys(article).forEach(key => {
            if (article[key] === undefined) {
                delete article[key];
            }
        });
        return this.findOneAndUpdate(query, article, {
            upsert: true
        });
    }

}

module.exports = Compose;
