'use strict';

const Document = require('camo').Document;

class Image extends Document {
    constructor() {
        super();
        this.schema({
            // CDN
            file: {
                type: String,
                required: true
            },
            // 本地
            sourceFile: {
                type: String,
                required: true
            },
            platformUrl: {
                type: String,
                required: false
            },
            platformInfo: {
                type: Object,
                required: false
            },
            // 平台
            type: {
                type: String,
                required: false
            }
        });
    }

    static addImage(imgData) {
        // 删除_schema否则会报错
        delete imgData._schema;
        // 过滤undefined，否则也会报错
        Object.keys(imgData).forEach(key => {
            if (imgData[key] === undefined) {
                delete imgData[key];
            }
        });
        const image = this.create(imgData);
        return image.save();
    }
    //
    // static getImagebyCDN(url) {
    //     return this;
    // }

    // static getImagebyPath(path) {
        // Api.getImagebyPath = function (path) {
        //     return DB.query(function (doc, emit) {
        //         if (doc.data.file === path) {
        //             emit(doc);
        //         }
        //     }, {
        //         include_docs: true
        //     }).then(function (res) {
        //         return res;
        //     });
        // };
    //     return;
    // }

    // static updateItem(id, attr) {
        // Api.updateItem = function (id, attr) {
        //     return DB.get(id)
        //     .then(function (res) {
        //         return DB.put({
        //             _id: res._id,
        //             _rev: res._rev,
        //             data: Object.assign(res.data, attr)
        //         });
        //     });
        // };
    //     return;
    // }
}

module.exports = Image;
