'use strict';

const Document = require('camo').Document;

class ReportData extends Document {
    constructor() {
        super();
        this.schema({
            beginDate: {
                type: String,
                required: true
            },
            endDate: {
                type: String,
                required: true
            },
            type: {
                type: String,
                required: true
            },
            dataList: {
                type: Object,
                required: false
            },
            updateTime: {
                type: Date,
                required: false
            },
            accountId: {
                type: String,
                required: true
            }
        });
    }
}

module.exports = ReportData;
