'use strict';

const Document = require('camo').Document;

class Sync extends Document {
    constructor() {
        super();
        // TODO: Embedded Documents
        this.schema({
            article_id: {
                type: String,
                required: true
            },
            account_uid: {
                type: String,
                required: true
            },
            // 同步基本信息，账号头像，账号名，平台信息
            account_info: {
                type: Object,
                required: false
            },
            // 以下信息新建时不需要·
            createtime: {
                type: Date,
                required: false
            },
            updatetime: {
                type: Date,
                required: false
            },
            // 文章类型： Article 单图文， MutiArticle 多图文
            type: {
                type: String,
                required: false
            },
            /*
                同步状态：
                    0: 等待，
                    1：同步中，
                    2：同步成功，
                    -1：同步失败
            */
            status: {
                type: Number,
                required: false
            },
            // 同步失败错误记录
            error: {
                type: String,
                required: false
            }
        });
    }


    // 添加和保存都以article_id，account_uid为主键，所以不需要传query
    static saveSyncRecord(s) {
        const syncRecord = Object.assign({}, s);
        // 删除_schema否则会报错
        delete syncRecord._schema;
        // 过滤undefined，否则也会报错
        Object.keys(syncRecord).forEach(key => {
            if (syncRecord[key] === undefined) {
                delete syncRecord[key];
            }
        });

        return this.findOne({
            'account_uid': syncRecord.account_uid,
            'article_id': syncRecord.article_id,
        }).then(data => {
            syncRecord.updatetime = new Date();
            if (data) {
                syncRecord.createtime = syncRecord.createtime || data.createtime;
                console.log(syncRecord.status);
                return this.findOneAndUpdate({ _id: data._id }, syncRecord);
            }
            syncRecord.createtime = new Date();
            syncRecord.status = 0;
            const _syncRecord = this.create(syncRecord);
            return _syncRecord.save();
        });
    }
}

module.exports = Sync;
