'use strict';

const fs = require('fs');
const path = require('path');
const models = {};
const connect = require('camo').connect;

fs.readdirSync(__dirname)
.filter(function (file) {
    return (file.indexOf('.') !== 0) && (file !== 'index.js');
})
.forEach(function (file) {
    const model = require(path.join(__dirname, file));
    models[path.basename(file, '.js')] = model;
});

module.exports = function (app) {
    const uri = `nedb://${app.materialDir}/data`;
    app.models = models;
    return connect(uri).then(function (db) {
        app.db = db;
        app.dbReady = true;
        app.emit('dbready', db);
    });
};
