'use strict';

const Document = require('camo').Document;
const queue = {
    status: false,
    list: []
};

class Temp extends Document {
    constructor() {
        super();
        this.schema({
            type: {
                type: String,
                required: true
            },
            data: {
                type: Object,
                required: true
            },
        });
    }

    static get(query, option = {}) {
        return this.findOne(query, option).then(res => (res ? res.data : null));
    }

    static save(args) {
        queue.list.push(args);
        if (!queue.status) {
            this.queue();
        }
    }

    static delete(query, option = {}) {
        return this.deleteMany(query, option);
    }

    // 保存临时数据，由于有并发的情况，采用队列处理
    static queue() {
        queue.status = true;
        this.queueStart(queue.list[0]);
    }

    static queueStart(data) {
        this.queueSave(data).then(() => {
            queue.list.splice(0, 1);
            if (queue.list.length > 0) {
                this.queue();
            } else {
                queue.status = false;
            }
        });
    }

    static queueSave(data) {
        return this.findOneAndUpdate({ type: data.type }, data, { upsert: true });
    }
}

module.exports = Temp;
