'use strict';

module.exports = (ctx, next) => {
    if (ctx.path[0] !== 'article' || !ctx.body) return next();
    const article = ctx.body;
    // 去除文章content的换行
    Object.keys(article).forEach(key => {
        const item = article[key];
        if (item && item.content) {
            item.content = item.content.replace(/\r|\n/g, '');
        }
    });
    return next();
};
