const needle = require('needle');
const querystring = require('querystring');

function resolveBaiduImage(str) {
    const map = {
        w: 'a',
        k: 'b',
        v: 'c',
        1: 'd',
        j: 'e',
        u: 'f',
        2: 'g',
        i: 'h',
        t: 'i',
        3: 'j',
        h: 'k',
        s: 'l',
        4: 'm',
        g: 'n',
        5: 'o',
        r: 'p',
        q: 'q',
        6: 'r',
        f: 's',
        p: 't',
        7: 'u',
        e: 'v',
        o: 'w',
        8: '1',
        d: '2',
        n: '3',
        9: '4',
        c: '5',
        m: '6',
        0: '7',
        b: '8',
        l: '9',
        a: '0',
        _z2C$q: ':',
        '_z&e3B': '.',
        AzdH3F: '/'
    };
    const reg1 = /([a-w\d])/g;
    const reg2 = /(_z2C\$q|_z&e3B|AzdH3F)/g;
    if (!str) {
        return '';
    }

    const o = str.replace(reg2, function (t, n) {
        return map[n];
    });
    return o.replace(reg1, function (t, n) {
        return map[n];
    });
}

function getSearchImageList(key, page, limit) {
    const query = {
        tn: 'resultjson_com',
        ipn: 'rj',
        ct: 201326592,
        is: '',
        fp: 'result',
        queryWord: key,
        cl: 2,
        lm: -1,
        ie: 'utf-8',
        oe: 'utf-8',
        adpicid: '',
        st: '',
        z: '',
        ic: '',
        word: key,
        s: '',
        se: '',
        tab: '',
        width: '',
        height: '',
        face: '',
        istype: '',
        qc: '',
        nc: '',
        fr: '',
        pn: page,
        rn: limit,
        gsm: '1e'
    };
    return new Promise(function (resolve, reject) {
        needle.get(`http://image.baidu.com/search/acjson?${querystring.stringify(query)}`, {
            decode_response: false
        }, function (err, resp) {
            if (err) {
                reject(err);
                return;
            }
            const res = JSON.parse(resp.body);
            res.data.splice(res.data.length - 1, 1);
            res.data.forEach(item => {
                item.objURL = resolveBaiduImage(item.objURL);
            });
            resolve(res);
        });
    });
}

module.exports = {
    getSearchImageList
};
