'use strict';
const co = require('co');
const CacheModel = require('../../model/CacheData');

module.exports = function (app) {
    app.use(co.wrap(function*(ctx, next) {
        console.warn(!ctx.message.notFromCache);
        if (ctx.message.cache && !ctx.message.notFromCache) {
            const cacheId = JSON.stringify(Object.assign({}, ctx.message, {
                cache: null,
                notFromCache: null,
                timeout: null
            }));
            const cache = yield CacheModel.findOne({
                cacheId
            });
            // 没有设置过期时间或者在过期时间内则使用缓存
            if (cache && (!cache.timeout || (Date.now() - cache.createtime.valueOf() < cache.timeout))) {
                console.log('use cache', cache);
                ctx.body = cache.data;
                return;
            }
        }
        yield next();
    }));
    app.use(co.wrap(function*(ctx, next) {
        yield next();
        if (ctx.message.cache) {
            console.log('set cache::');
            // 防止cache的参数变化导致无法更新cache
            const cacheId = JSON.stringify(Object.assign({}, ctx.message, {
                cache: null,
                notFromCache: null,
                timeout: null
            }));
            let cache = yield CacheModel.findOne({
                cacheId
            });
            if (!cache) {
                cache = CacheModel.create({});
                cache.cacheId = cacheId;
            }
            cache.data = ctx.body;
            cache.timeout = ctx.message.timeout;
            cache.createtime = new Date();
            console.log(cache);
            yield cache.save();
        }
    }));
};
