'use strict';

const co = require('co');
const Collection = require('./collection');
const AppConfig = require('../../model/AppConfig');
const PlatformApiConfig = require('../../config/platform');

module.exports = function (app) {
    const { PlatformApi, WxbApi, clientId } = app;

    const api = {};
    const wxbapi = {
        saveSyncAccountClient: WxbApi.saveSyncAccountClient
    };
    let apiname;
    Object.keys(PlatformApiConfig).forEach(platform => {
        apiname = PlatformApiConfig[platform].apiName;
        api[platform] = PlatformApi[apiname];
        wxbapi[`saveSync${platform}FansSummary`] = WxbApi[`saveSync${apiname}FansSummary`];
    });

    let ctn;

    try {
        AppConfig.findOne().then(function (res) {
            ctn = new Collection(api, wxbapi, clientId, res ? res.token : null);
        });
        setTimeout(function () {
            app.sendMessage({
                name: '/account/getAccountList'
            }).then(function (r) {
                const list = r.body.rows;
                ctn.start(list);

                // ctn.cleanDB();
                // ctn.getDB();
            });
        }, 60000);
    } catch (e) {
        throw new Error(e);
    }

    app.use(co.wrap(function*(ctx, next) {
        if (!ctx.match('/account/save')) {
            yield next();
            return;
        }
        const { userInfo } = ctx.message;

        try {
            ctn.start([userInfo]);
        } catch (e) {
            console.error(e.message);
        }
        yield next();
    }));
};
