'use strict';
const os = require('os');

function sendLog(ctx) {
    // message的内容太大，先不上传
    // 如果有用户信息，删除掉用户的密码
    // if (ctx.message.userInfo) {
    //     delete ctx.message.userInfo.password;
    // }
    // html代码太大，过滤掉
    // delete ctx.message.html;
    // ctx.log(ctx.message);
    // ctx.log(ctx.body);
    console.log(ctx);
    console.log('log stack---------');
    console.log(ctx.logStack);
    if (ctx.app.manifest.evn !== 'develop') {
        ctx.app.WxbApi.sendError(ctx.logStack).then(() => {
            console.log('send error success.');
        });
    }
}

module.exports = function (app) {
    app.startTime = new Date();
    app.use(function (ctx, next) {
        ctx.logStack = [];
        ctx.log = function () {
            for (let i = 0; i < arguments.length; i++) {
                const item = arguments[i];
                if (typeof(item) == 'object') {
                    const current = Object.assign({}, item);
                    delete current._schema;
                    ctx.logStack.push(current);
                } else {
                    ctx.logStack.push(item);
                }
            }
        };
        ctx.clearLog = function () {
            ctx.logStack = [];
        };
        ctx.log(ctx.name);
        const baseInfo = {
            version: ctx.app.manifest.version,
            build: ctx.app.manifest.build,
            platform: os.platform(),
            release: os.release(),
            uptime: (new Date()) - app.startTime,
            clientId: app.clientId
        };
        ctx.log(baseInfo);
        ctx.sendLog = function () {
            sendLog(ctx);
        };
        ctx.resetLog = function () {
            ctx.logStack = [];
            ctx.log(ctx.name);
            ctx.log(baseInfo);
        };
        return next();
    });

    app.on('error', function (err, ctx) {
        ctx.log(err.message || err);
        sendLog(ctx);
    });
};
