'use strict';

const pathToRegExp = require('path-to-regexp');
/**
 * Context prototype.
 */

module.exports = {
    // 判断当前url跟传入的正则是否匹配
    match: function (regStr) {
        const regexp = pathToRegExp(regStr);
        return regexp.test(this.name);
    },
    onerror: function (err) {
        // don't do anything if there is no error.
        // this allows you to pass `this.onerror`
        // to node-style callbacks.
        if (null == err) return;

        if (!(err instanceof Error)) err = new Error(err);
        // delegate
        this.app.emit('error', err, this);

        return Promise.reject(err);
    }
};
