
function Monitor() {
    this.count = {};
    this.time = {};
}

Monitor.prototype.getNewCount = function () {
    return {
        count: 1
    };
};

Monitor.prototype.getNewTime = function (time) {
    return {
        start_time: time,
        end_time: null,
        time: 0
    };
};

Monitor.prototype.saveCount = function (data) {
    const date = new Date();
    const year = date.getFullYear();
    const month = date.getMonth() + 1;
    const day = date.getDate();
    const hour = date.getHours();
    const start = new Date(`${year}/${month}/${day} ${hour}:00:00`).getTime();
    const end = new Date(`${year}/${month}/${day} ${hour + 1}:00:00`).getTime();
    const key = `${start}_${end}`;
    const path = data.path.join(',');

    if (!this.count[path]) {
        this.count[path] = {
            [key]: this.getNewCount()
        };
    } else {
        if (!this.count[path][key]) {
            this.count[path][key] = this.getNewCount();
        } else {
            this.count[path][key].count++;
        }
    }
};

Monitor.prototype.hasPath = function (type, path) {
    path = path.split(',');
    let l = 0;
    let has = false;
    path.forEach((item, key) => {
        if (type[key] && item.indexOf(type[key]) !== -1) {
            l++;
        }
    });

    if (l === type.length) has = true;

    return has;
};

Monitor.prototype.setTimeListClose = function (list, time) {
    return list.map(item => {
        if (!item.end_time) {
            item.end_time = time;
            item.time = time - item.start_time;
        }

        return item;
    });
};

Monitor.prototype.onClose = function (args) {
    const self = this;

    if (args.path) {
        args.path.forEach(item => {
            if (this.time[item]) {
                this.time[item].list = self.setTimeListClose(this.time[item].list, args.time);
            }
        });
    }

    if (args.type === 'all') {
        Object.keys(this.time).forEach(item => {
            this.time[item].list = self.setTimeListClose(this.time[item].list, args.time);
        });
    }

    if (args.type.length) {
        Object.keys(this.time).forEach(item => {
            if (self.hasPath(args.type, item)) {
                this.time[item].list = self.setTimeListClose(this.time[item].list, args.time);
            }
        });
    }
};

Monitor.prototype.saveTime = function (data) {
    const time = new Date().getTime();
    if (data.close) {
        this.onClose({
            type: data.close,
            time
        });
    } else {
        const path = data.path.join(',');
        if (!this.time[path]) {
            this.time[path] = {
                path: data.path,
                list: [this.getNewTime(time)]
            };
        } else {
            this.onClose({
                path: [path],
                time
            });
            switch (data.status) {
            case 0: {
                this.time[path].list.push(this.getNewTime(time));
                break;
            }
            default:
            }
        }
    }
};

Monitor.prototype.save = function (data) {
    switch (data.type) {
    case 'count':
        this.saveCount(data);
        break;
    case 'time':
        this.saveTime(data);
        break;
    default:
    }
};

Monitor.prototype.getCount = function () {
    return Object.keys(this.count).map(item => ({
        path: item.split(','),
        type: 'count',
        list: Object.keys(this.count[item]).map(it => {
            const times = it.split('_');
            return {
                start_time: times[0],
                end_time: times[1],
                count: this.count[item][it].count
            };
        })
    }));
};

Monitor.prototype.getTime = function () {
    const time = [];
    Object.keys(this.time).forEach(item => {
        const list = [];
        this.time[item].list.forEach((it, k) => {
            if (it.end_time !== null && it.time > 0) {
                list.push(it);
                this.time[item].list.splice(k, 1);
            }
        });
        if (list.length) {
            time.push({
                path: item.split(','),
                type: 'time',
                list
            });
        }
    });
    return time;
};

Monitor.prototype.getData = function () {
    const count = this.getCount();
    const time = this.getTime();
    this.count = {};

    return {
        count,
        time
    };
};

module.exports = Monitor;
