const co = require('co');
const Monitor = require('./Monitor');
const Events = require('./events');

module.exports = function (app) {
    app.monitor = new Monitor();

    const interval = setInterval(() => {
        app.sendMessage('/monitor/send');
    }, 20 * 60 * 1000);

    app.use(co.wrap(function*(ctx, next) {
        let data;
        Events.forEach(item => {
            if (ctx.match(item.event) && typeof item.handle === 'function') {
                data = item.handle(item.path, ctx.message);
                if (data instanceof Array) {
                    data.forEach(it => {
                        app.sendMessage({
                            name: '/monitor/save',
                            data: {
                                path: it.path,
                                type: item.type
                            }
                        });
                    });
                }
            }
        });
        yield next();
    }));
};
