const html = require('./html');
const base = require('./base');
const PLAT_FORM = require('../../config/platform');
const _ = require('lodash');
const {
    getImagesUrl,
    replaceHtmlImagesUrl,
    getLocalImagesUrl,
    getRemoteImagesUrl,
    simpleFormat
} = html;
const {
    removeFileProtocol
} = base;

// 获取文章中的所有图片url
function getArticleImages(article) {
    let l = [];
    Object.keys(article).forEach(function (key) {
        const item = article[key];
        if (item && item.content) {
            l = l.concat(getImagesUrl(item.content));
        }
    });
    return _.union(l); // 去重
}

// 将文章中的url地址
function replaceImagesUrl(article, images) {
    const values = Object.values(article);
    values.forEach(function (val) {
        if (val.content) {
            val.content = replaceHtmlImagesUrl(val.content, images);
        }
    });
    return article;
}


function getArticleCoverUrls(article) {
    const l = [];
    Object.values(article).forEach(val => {
        if (!val) {
            return;
        }
        const cover = val.cover;
        const covers = val.covers;
        if (cover && _.isString(cover)) {
            l.push(cover);
        } else if (cover && _.isObject(cover)) {
            l.push(removeFileProtocol(cover.file));
        } else if (covers) {
            covers.forEach(item => {
                l.push(removeFileProtocol(item.file));
            });
        }
    });
    return l;
}

// 获取平台封面图数组，传入：platformArticle:文章 conImgs 文章内容里所有的图片
function getPlatformCover(platformArticle) {
    const { cover } = platformArticle;
    if (cover && cover.type === 'normal') {
        return [cover.url];
    }
    if (cover && cover.type === 'select') {
        // cover.model 0 1 2
        switch (cover.model) {
        case 0:
            // content第一章图片
            // return [conImgs[0]];
            return null;
        case 1:
            return [cover.url[0]];
        case 2:
            return cover.url.map(url => url);
        default:
            return null;
        }
    }
    return null;
}

function replaceArticleCoverUrls(article, urlMap) {
    Object.keys(article).forEach(key => {
        const val = article[key];
        if (!val) return;
        const cover = val.cover;
        let covers = val.covers;
        if (cover && _.isString(cover) && urlMap[cover]) {
            article[key].cover = urlMap[cover];
        } else if (cover && _.isObject(cover)) {
            article[key].cover.file = urlMap[cover.file];
        } else if (covers) {
            covers = covers.map(item => {
                item.file = urlMap[item.file];
                return item;
            });
            article[key].covers = covers;
        }
    });
    return article;
}

function converToCloudUpload(article) {
    Object.keys(article).forEach(key => {
        const val = article[key];
        const cover = val.cover;
        if (cover && _.isObject(cover)) {
            article[key].cover = cover.file;
        }
    });
    return article;
}

function converToLocal(article) {
    Object.keys(article).forEach(key => {
        const val = article[key];
        const cover = val.cover;
        if (cover && _.isString(cover)) {
            article[key].cover = {
                file: cover
            };
        }
    });
    return article;
}

function replacePlatformCoverUrl(article, remoteList) {
    const cover = article.cover;
    console.warn('cover:::::::::___________');
    console.warn(cover);
    console.warn(remoteList);
    if (cover && cover.type === 'normal') {
        if (!cover.url) {
            throw new Error('请选择封面');
        }
        const matchImg = remoteList.filter(item => item.file === cover.url)[0];
        console.warn(matchImg);
        cover.url = matchImg.platformUrl;
        cover.platformInfo = matchImg.platformInfo;
    }
    if (cover && cover.type === 'select') {
        // cover.model 0 1 2
        switch (cover.model) {
        case 0: {
            // 头条默认选择文章中第一张图片，不要更改
            break;
        }
        case 1: {
            const matchImg = remoteList.filter(item => item.file === cover.url)[0];
            cover.url[0] = matchImg.platformUrl;
            cover.platformInfo = matchImg.platformInfo;
            break;
        }
        case 2: {
            cover.url = cover.url.map(url => {
                return remoteList.filter(item => item.file === url)[0].platformUrl;
            });
            break;
        }
        default: {
            return null;
        }
        }
    }
    article.cover = cover;
    return article;
}

// 获取一组文章中的所有图片数据，包括content和封面图片,去重
function getArticlesImages(articles) {
    let conImgs = [];
    let coverImgs = [];
    articles.forEach(article => {
        conImgs = conImgs.concat(getImagesUrl(article.content));
        if (article.cover.type == 'normal') {
            const _cover = getPlatformCover(article);
            if (_cover && _cover.length) {
                coverImgs = coverImgs.concat(_cover);
            }
        }
    });
    const images = _.uniq(conImgs.concat(coverImgs)); // 所有文章里的图片, 字符串数组，去重;
    return images;
}


// 获取本地图片路径
function getArticlesLocalImages(articles) {
    let conImgs = [];
    let coverImgs = [];
    articles.forEach(article => {
        conImgs = conImgs.concat(getLocalImagesUrl(article.content));
        const _cover = getPlatformCover(article);
        if (_cover && _cover.length) {
            coverImgs = coverImgs.concat(_cover);
        }
    });
    coverImgs = coverImgs.filter(item => item.indexOf('http') < 0);
    const images = _.uniq(conImgs.concat(coverImgs)); // 所有文章里的图片, 字符串数组，去重;
    return images;
}

function getArticlesRemoteImages(articles) {
    let conImgs = [];
    let coverImgs = [];
    articles.forEach(article => {
        conImgs = conImgs.concat(getRemoteImagesUrl(article.content));
        if (article.cover && article.cover.type == 'normal') {
            const _cover = getPlatformCover(article, conImgs);
            if (_cover && _cover.length) {
                coverImgs = coverImgs.concat(_cover);
            }
        }
    });
    coverImgs = coverImgs.filter(item => item && item.indexOf('http') == 0);
    const images = _.uniq(conImgs.concat(coverImgs));
    return images;
}


function getPlatformKeys(article) {
    const res = [];
    Object.keys(article).forEach(item => {
        const val = article[item];
        if (val && val.title && val.content) {
            res.push(item);
        }
    });
    return res;
}

function hasPlatformContent(article, checkList) {
    const hasKeys = getPlatformKeys(article);
    let has = 0;
    checkList.forEach(item => {
        if (hasKeys.includes(item)) {
            has++;
        }
    });
    return has == checkList.length;
}

// 文章数据中有一个checkMap，如果为false的字段则去除
function removeUncheckedAttr(article) {
    if (article.checkMap) {
        const checkMap = article.checkMap;
        Object.keys(checkMap).forEach(key => {
            if (checkMap[key] == false) {
                delete article[key];
            }
        });
    }
    return article;
}

// 简单处理，去除换行
function contentSimpleFormat(article) {
    Object.keys(article).forEach(key => {
        const item = article[key];
        if (item && item.content) {
            item.content = simpleFormat(item.content);
        }
    });
    return article;
}

// 获取文章的基本显示信息:标题，封面
const priority = Object.keys(PLAT_FORM).filter(item => item != 'all');
function getV1ArticleDisplayInfo(article) {
    const res = {};
    const platList = [];
    priority.forEach(function (key) {
        const con = article[key];
        if (!con) return;
        // 目前每个平台的标题都是title字段
        if (!res.title && con.title) {
            res.title = con.title;
        }
        // 获取封面不同平台的文章有差异，还需要处理
        if (!res.coverImage && typeof(con.cover) == 'string') {
            res.coverImage = con.cover;
        } else if (!res.coverImage && con.covers && con.covers[0]) {
            res.coverImage = con.covers[0].file;
        } else if (!res.coverImage && typeof(con.cover) == 'object') {
            res.coverImage = con.cover.file;
        }
        if (con.title && con.content) {
            platList.push(key);
        }
    });
    res.coverImage = res.coverImage || 'http://s.weituibao.com/site/images/1475217800554/editor-tuwen-default-avator.png';
    res.platform = platList;
    return res;
}

// 导入数据转换
function convertV1ArticleData(data) {
    // 处理封面
    //
    // 上传并转换本地图片
    return data;
}

module.exports = {
    getArticleImages,
    getArticlesLocalImages,
    replaceImagesUrl,
    getArticleCoverUrls,
    replaceArticleCoverUrls,
    converToCloudUpload,
    converToLocal,
    getPlatformCover,
    replacePlatformCoverUrl,
    getArticlesImages,
    getPlatformKeys,
    hasPlatformContent,
    removeUncheckedAttr,
    getArticlesRemoteImages,
    contentSimpleFormat,
    getV1ArticleDisplayInfo,
    convertV1ArticleData
};
