const moment = require('moment');

function fullTime(t) {
    return moment(t).format('YYYY-MM-DD hh:mm:ss');
}

function removeFileProtocol(url) {
    return url.replace('file://', '');
}

function addFileProtocol(url) {
    if (url.indexOf('file://') == 0) {
        return url;
    }
    return `file://${url}`;
}

function parseObjectString(str) {
    const f = new Function('return ' + str);
    return f();
}

module.exports = {
    fullTime,
    removeFileProtocol,
    addFileProtocol,
    parseObjectString
};
