const _ = require('lodash');
const OnlineImgReg = /<img.*? src=["'](.*?)["'].*?>/g; // src 前有一个空格，就可以过滤掉data-src的匹配
const backgroundReg = /background.*?url\s*\(["']?(.*?)["']?\)/g;

function _getAllImgUrl(html) {
    const l = [];
    let _match;
    while ((_match = OnlineImgReg.exec(html)) != null) {
        l.push(_match[1]);
    }
    while ((_match = backgroundReg.exec(html)) != null) {
        l.push(_match[1]);
    }
    return _.uniq(l);
}
function getImgSrc(html) {
    return _getAllImgUrl(html).map(url => (url.replace('file://', '')));
}

function getImagesUrl(html) {
    return _getAllImgUrl(html).map(url => (url.replace('file://', '')));
}

function getLocalImagesUrl(html) {
    const l = _getAllImgUrl(html);
    const res = [];
    l.forEach(url => {
        if (url.indexOf('file://') === 0) {
            let _p = url.replace('file://', '');
            // windows下可能会出现这样/d:/abc/的路径，要去掉开头的斜杠
            if (_p.match(/^\/\w*:/)) {
                _p = _p.substring(1, _p.length);
            }
            res.push(_p);
        }
    });
    return res;
}

function getRemoteImagesUrl(html) {
    const l = _getAllImgUrl(html);
    const res = [];
    l.forEach(url => {
        if (url.indexOf('http') === 0) {
            res.push(url);
        }
    });
    return res;
}


function replaceHtmlImagesUrl(content, images) {
    let _con = content;
    Object.keys(images).forEach(function (from) {
        // 避免正则替换出问题，直接使用单词replace方法
        if (from !== images[from]) {
            while (_con.indexOf(from) > -1) {
                _con = _con.replace(from, images[from]);
            }
        }
    });
    return _con;
}

function simpleFormat(html) {
    return html.replace(/\r|\n/g, '');
}

module.exports = {
    getImgSrc,
    getImagesUrl,
    getRemoteImagesUrl,
    getLocalImagesUrl,
    replaceHtmlImagesUrl,
    simpleFormat
};
