const needle = require('needle');
const needleMethod = ['post', 'get', 'head', 'put', 'request', 'patch'];
const proxy = {};
needleMethod.forEach(name => {
    proxy[name] = function (...args) {
        return new Promise(function (resolve, reject) {
            args.push(function (err, res, body) {
                if (err) {
                    reject(err);
                    return;
                }
                const opt = args[args.length - 2];
                if (opt && opt.parseJson && body) {
                    resolve(JSON.parse(body));
                } else if (opt.multiReturn) {
                    resolve({
                        res,
                        body
                    });
                } else {
                    resolve(body);
                }
            });
            needle[name].apply(needle, args);
        });
    };
});

module.exports = proxy;
