const parseUrl = require('url');
const http = require('http');
const sizeOf = require('image-size');

function getImageInfo(url) {
    const options = parseUrl.parse(url);

    return new Promise(resolve => {
        http.get(options, function (response) {
            const chunks = [];
            response.on('data', function (chunk) {
                chunks.push(chunk);
            }).on('end', function () {
                const buffer = Buffer.concat(chunks);
                const ret = sizeOf(buffer);
                ret.ratio = ret.height / ret.width;
                resolve(ret);
            });
        });
    });
}

module.exports = {
    getImageInfo
};
