function getSyncRecordsStatus(syncRecords) {
    /*
        同步状态：
            0: 等待，
            1：同步中，
            2：同步成功，
            3: 部分同步成功
            -1：同步失败
            -2: 已取消
        一篇文章的同步状态：
            如果全部平台都为等待中，则该文章状态为等待中
            如果所有平台中有一个平台在同步中或等待中，则该文章状态为同步中
            如果所有平台都同步失败，则该文章状态为同步失败
            如果全部平台都同步成功，则该文章状态为同步成功
            如果一部分同步成功一部分同步失败，则该文章状态为部分同步成功
    */
    if (!syncRecords.length) return null;
    const syncRecordStatus = syncRecords.map(syncRecord => syncRecord.status);
    if (syncRecordStatus.includes(1)) return { status: 1, text: '同步中' }; // 同步中
    if (syncRecordStatus.includes(0)) return { status: 0, text: '等待中' }; // 等待中
    // if (syncRecordStatus.includes(2) && syncRecordStatus.includes(-1)) return 3; // 部分同步成功
    if (syncRecordStatus.includes(2)) {
        if (syncRecordStatus.includes(-1)) return { status: 3, text: '部分同步成功' }; // 部分同步成功
        return { status: 2, text: '同步成功' }; // 同步成功
    }
    if (syncRecordStatus.includes(-1)) return { status: -1, text: '同步失败' }; // 同步失败
    return { status: -2, text: '已取消' }; // 已取消
}

module.exports = {
    getSyncRecordsStatus
};
