const co = require('co');
const Config = require('./config');

module.exports = function (app) {
    function execWatch(path) {
        if (app.watch && app.watch[path]) {
            app.watch[path].forEach(ob => {
                ob.callback();
            });
        }
    }

    app.use(co.wrap(function*(ctx, next) {
        yield next();
        const { message } = ctx;
        const trigger = Config[message.name];
        if (trigger) {
            if (typeof trigger === 'string') {
                execWatch(trigger);
            } else if (trigger instanceof Array) {
                trigger.forEach(path => {
                    execWatch(path);
                });
            }
        }
    }));
};
