const Emitter = require('events');
const Util = require('../util');
const agent = 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) ' +
    'Chrome/39.0.2171.95 Safari/537.36 MicroMessenger/6.5.2.501 NetType/WIFI WindowsWechat';

class Spider extends Emitter {
    constructor(decoder) {
        super();
        this.accounts = []; // 需要抓取的账号列表
        this.secretUrl = null; // 服务器端获取过来的secret
        this.decoder = decoder; // 解密方法
        this.status = null;
        this.done = 0;
        this.success = 0;
        this.failure = 0;
    }

    init() {
        return this.getSecretUrl().then(url => {
            if (url) {
                this.status = 0;
                this.secretUrl = url;
            }
            return url;
        });
    }

    start(accounts) {
        if (this.status != 0) {
            return;
        }
        this.accounts = accounts;
        this._crawl(0, 0);
    }

    getSecretUrl() {
        return Util.Http.get(`http://api.wxb.com/follow/secret?_=${Math.random()}`, {}).then(res => {
            const ret = [];
            let _secretUrl = '';
            JSON.parse(res).data.forEach((item) => {
                ret.push(this.decoder(item));
            });
            ret.forEach(url => {
                if (url.split('key=').length > 1 &&
                    url.split('uin=').length > 1 &&
                    url.split('pass_ticket=').length > 1 &&
                    !_secretUrl) {
                    _secretUrl = url;
                }
            });
            return _secretUrl;
        });
    }

    _crawl(index, retry) {
        if (index < this.accounts.length) {
            const account = this.accounts[index];
            if (retry > 2) {
                this._crawl(index + 1, 0);
                this.done++;
                this.failure++;
                this.emit('oneFailure', account);
                return;
            }
            let tokenObj;
            this.getToken(this.secretUrl).then(tokenRes => {
                // 获取图文列表url
                tokenObj = tokenRes;
                return this.getAccountMsgList(tokenRes, account);
            })
            .then(listRes => {
                if (listRes && listRes.length) {
                    return this.getMsgDetail(listRes, tokenObj);
                }
                return null;
            })
            .then(data => {
                // console.log(data);
                // 获取到了文章数据
                // 保存到服务器端
                this.saveToServer(data, account);
                this._crawl(index + 1, 0);
                this.done++;
                this.success++;
                this.emit('oneSuccess', account);
                console.log('抓取微信文章-账号-', index);
            })
            .catch(e => {
                console.log('抓取微信文章失败，重试.', e);
                this._crawl(index, retry + 1);
            });
        }
    }

    getToken(url) {
        return Util.Http.get(url, { multiReturn: true }).then((response) => {
            let token;
            if (response && response.body.match) {
                token = response.body.match(/window\.wxtoken\s*=\s*"(\d+)";?/);
            }
            const result = {
                token: token ? token[1] : '',
                key: this.secretUrl.split('key=')[1].split('&')[0],
                uin: this.secretUrl.split('uin=')[1].split('&')[0],
                pass_ticket: this.secretUrl.split('pass_ticket=')[1],
                cookiesMap: response.res.cookies
            };
            result.passKeys = `&uin=${result.uin}&key=${result.key}&pass_ticket=${result.pass_ticket}`;
            return result;
        });
    }

    getAccountMsgList(tokenRes, account) {
        // 获取最近一篇图文
        const getListUrl = `http://mp.weixin.qq.com/mp/getmasssendmsg?__biz=${account.wx_biz}${tokenRes.passKeys}&f=json`;
        return Util.Http.get(getListUrl, {
            cookies: tokenRes.cookiesMap,
            headers: {
                'User-Agent': agent
            }
        }).then(listRes => {
            if (!listRes) {
                throw new Error('文章内容获取失败');
            }
            if (listRes.ret === 0) {
                if (listRes.count === 0) {
                    return [];
                }
                const generalMsgList = JSON.parse(listRes.general_msg_list);
                const resultUrls = [];
                if (generalMsgList && generalMsgList.list.length > 0) {
                    generalMsgList.list.forEach((item) => {
                        const appMsgExtInfo = item.app_msg_ext_info;
                        if (!appMsgExtInfo) {
                            return; // 没有 app_msg_ext_info 说明发的是非图文消息
                        }
                        if (appMsgExtInfo && appMsgExtInfo.content_url) {
                            let url = appMsgExtInfo.content_url.replace(/&amp;/g, '&');
                            url = url.replace(/#.+/gim, '');
                            url += tokenRes.passKeys;
                            resultUrls.push(url);
                        }
                        if (appMsgExtInfo.is_multi === 1) {
                            appMsgExtInfo.multi_app_msg_item_list.forEach(itemIn => {
                                if (itemIn && itemIn.content_url) {
                                    let url2 = itemIn.content_url.replace(/&amp;/g, '&');
                                    url2 = url2.replace(/#.+/gim, '');
                                    url2 += tokenRes.passKeys;
                                    resultUrls.push(url2);
                                }
                            });
                        }
                    });
                }
                return resultUrls;
            }
            return [];
        });
    }

    getMsgDetail(urlList, tokenObj) {
        return Promise.all(urlList.map(item => {
            return this._requestMsgDetail(item, tokenObj);
        }));
    }

    getMpMsgExtInfo(url, cookiesMap) {
        const biz = this.getParam(url, '__biz');
        const mid = this.getParam(url, 'mid');
        const sn = this.getParam(url, 'sn');
        const idx = this.getParam(url, 'idx');
        const uin = this.getParam(url, 'uin');
        const key = this.getParam(url, 'key');
        const passTicket = this.getParam(url, 'pass_ticket');
        const Referer = 'http://mp.weixin.qq.com/s?__biz=' + biz + '&mid=' + mid + '&idx=' + idx + '&sn=' + sn + '&scene=4&uin=' + uin + '&key=' + key + '&pass_ticket=' + passTicket;

        return Util.Http.post(url, {
            is_only_read: 1
        }, {
            cookies: cookiesMap,
            headers: {
                'User-Agent': agent,
                'Referer': Referer,
                'Origin': 'http://mp.weixin.qq.com/',
                'X-Requested-With': 'XMLHttpRequest',
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
                'Content-Length': 0,
                'Cache-Control': 'max-age=0'
            }
        }).then((body) => {
            const msgInfo = {};
            const result = body;
            if (result.base_resp && result.base_resp.ret === 301) {
                return null;
            }
            if (result.appmsgstat && result.appmsgstat.read_num) {
                msgInfo.read_num = Math.max(result.appmsgstat.read_num, result.appmsgstat.real_read_num);
                msgInfo.like_num = result.appmsgstat.like_num;
                return msgInfo;
            }
            return null;
        });
    }

    getParam(url, key) {
        url = url || '';
        url = url.replace(/#.+/g, '');
        const temp = url.split('?')[1].split('&');
        for (let i = 0; i < temp.length; i++) {
            const obj = temp[i];
            const pos = obj.search('=');
            if (obj.substr(0, pos) === key) {
                return obj.substr(pos + 1);
            }
        }
        return '';
    }

    _requestMsgDetail(url, tokenObj) {
        url = url.replace(/#.+/, '');
        if (url.indexOf('?') < 0) {
            url += '?';
        }
        url += '&f=json';
        const biz = this.getParam(url, '__biz');
        const mid = this.getParam(url, 'mid');
        const sn = this.getParam(url, 'sn');
        const idx = this.getParam(url, 'idx');
        const uin = this.getParam(url, 'uin');
        const key = this.getParam(url, 'key');
        const passTicket = this.getParam(url, 'pass_ticket');
        return Util.Http.get(url, {
            cookies: tokenObj.cookiesMap,
            headers: {
                'User-Agent': agent
            }
        }).then(response => {
            const result = response;
            if (result.base_resp.ret === 0) {
                const msgInfo = {
                    title: result.title,
                    ori_create_time: result.ori_create_time,
                    cover: result.cdn_url,
                    link: result.link.replace(/&amp;/g, '&'),
                    desc: result.desc,
                    is_original: result.copyright_info && result.copyright_info.copyright_stat === 1 ? 1 : 0,
                    content_type: 0,
                    idx: idx
                };
                if (result.content.match(/v.qq.com\/iframe\/preview/im) != null) {
                    msgInfo.content_type = 1;
                }
                if (tokenObj.token) {
                    const postUrl = [
                        'http://mp.weixin.qq.com/mp/getappmsgext?__biz=',
                        biz,
                        '&appmsg_type=9',
                        '&mid=',
                        mid,
                        '&idx=',
                        idx,
                        '&sn=',
                        sn,
                        '&scene=4',
                        '&title=',
                        encodeURIComponent(result.title),
                        '&ct=',
                        result.ori_create_time,
                        '&devicetype=android-19&version=&f=json&r=',
                        Math.random(),
                        '&is_need_ad=1&comment_id=0&is_need_reward=0&both_ad=1&reward_uin_count=0',
                        '&uin=',
                        uin,
                        `&key=${key}`,
                        `&pass_ticket=${passTicket}`,
                        `&wxtoken=${tokenObj.token}`,
                        '&devicetype=android-19&clientversion=637732920&x5=0'
                    ].join('');

                    return this.getMpMsgExtInfo(postUrl).then(function (info) {
                        if (info) {
                            msgInfo.read_num = info.read_num;
                            msgInfo.like_num = info.like_num;
                        }
                        return msgInfo;
                    });
                }
                return msgInfo;
            }
            return Promise.resolve(null);
        });
    }

    saveToServer(articles, account) {
        return Util.Http.post('http://api.wxb.com/client/saveback', {
            t: 'following',
            d: {
                raw_id: account.wx_origin_id,
                id: account.id,
                articles
            }
        });
    }

    stop() {

    }

    getStatus() {
        return {
            status: this.status,
            done: this.done,
            success: this.success,
            failure: this.failure
        };
    }
}

module.exports = Spider;
