/**
 * 账号管理相关接口
 */
// const base = require('./base');
module.exports = function (base) {
    return {
        getWeiXinAuthorQr(token) {
            const _sign = base.sign({
                token,
                source: 'multi'
            });
            return base.post('/auth/getMpWechatUrl2', _sign.string);
        },
        removeWeiXinAuthor(token, id) {
            const _sign = base.sign({
                token,
                id
            });
            return base.post('/auth/deleteMpWechat', _sign.string);
        },
        getWeiXinAuthorList(token, verifyType) {
            const _sign = base.sign({
                token,
                verify_type: verifyType || ''
            });
            return base.get('/auth/getMpWechatList', _sign.string);
        },
        getWeixinQrStatus(timespam, uuid) {
            return base.get(`https://mp.weixin.qq.com/safe/safeuuid?timespam=${timespam}&uuid=${uuid}&token=&lang=zh_CN&f=json&ajax=1&random=${Math.random()}&_=`);
        },
        weixinAuthCallback(query, uuid) {
            return base.get(`http://api.wxb.com/auth/callback?${query}&uuid=${uuid}&_=`);
        },
        getAccountCloudList(token, opt) {
            const option = Object.assign({}, opt, { token });
            const _sign = base.sign(option);
            return base.get('/user-account/list', _sign.string);
        }
    };
};
