/**
 * 云端素材相关接口
 */
const _ = require('lodash');
module.exports = function (base) {
    return {
        getSingelMaterials(token, args) {
            args.token = token;
            const _sign = base.sign(args);
            return base.get('/user-article/list', _sign.string);
        },
        uploadSingelMaterial(token, data) {
            const innerKeys = ['omqq', 'qq', 'toutiao',
                'weixin', 'weibo', 'yidianzixun', 'jianshu', 'sohu', 'zhihu', 'uc', 'baijiahao', 'relation_data'];
            const _data = _.pick(data, ['id', 'ctime'].concat(innerKeys));
            innerKeys.forEach(key => {
                const val = _data[key];
                if (!val) return;
                if (key == 'relation_data') return;
                Object.keys(val).forEach(item => {
                    const keyVal = val[item];
                    if ((_.isObject(keyVal) || _.isArray(keyVal)) &&
                        ['covers', 'cover', 'channelId'].indexOf(item) === -1) {
                        delete _data[key][item];
                    }
                });
            });
            _data.token = token;
            console.log(_data);
            const _sign = base.sign(_data);
            innerKeys.forEach(key => {
                const val = _sign.data[key];
                if (!val) return;
                _sign.data[key] = base.fixedEncodeURIComponent(JSON.stringify(val));
            });
            console.log('同步字段：', _sign.data.weixin, _sign.weixin);
            return base.post('/user-article/save', _sign.string);
        },
        getCloudMutiMaterials(token, args = {}) {
            args.token = token;
            const _sign = base.sign(args);
            return base.get('/user-news/list', _sign.string);
        },
        uploadMutiMaterial(token, data) {
            const innerKeys = ['qq', 'weixin'];
            const _data = _.pick(data, ['relation_data',
                'platforms', 'id', 'ctime'].concat(innerKeys));
            innerKeys.forEach(key => {
                const val = _data[key];
                if (!val) return;
            });
            _data.token = token;
            console.log(_data);
            const _sign = base.sign(_data);
            innerKeys.forEach(key => {
                const val = _sign.data[key];
                if (!val) return;
                _sign.data[key] = base.fixedEncodeURIComponent(JSON.stringify(val));
            });
            console.log(_sign.data);
            return base.post('/user-news/save', _sign.data);
        },
        delCloudMutiMaterials(token, id) {
            const _sign = base.sign({
                token,
                id
            });
            return base.post('/user-news/remove', _sign.string);
        }
    };
};
