/**
 * 我的收藏相关接口
 */
// const base = require('./base');

module.exports = function (base) {
    return {
        getFavoriteList(token, groupId, args = {}) {
            args.token = token;
            if (groupId) {
                args.group_id = groupId;
            }
            const _sign = base.sign(args);
            return base.get('/favorite/list', _sign.string);
        },
        getFavoriteGroup(token) {
            const _sign = base.sign({
                token
            });
            return base.get('/favorite/getGroup', _sign.string);
        },
        addFavoriteGroup(token, name) {
            const _sign = base.sign({
                token,
                name
            });
            return base.post('/favorite/groupAdd', _sign.string);
        },
        delFavoriteGroup(token, id) {
            const _sign = base.sign({
                token,
                id
            });
            return base.post('/favorite/groupDel', _sign.string);
        },
        updateFavoriteGroup(token, id, name) {
            const _sign = base.sign({
                token,
                id,
                name
            });
            return base.post('/favorite/groupModify', _sign.string);
        },
        addFavorite(token, args = {}) {
            args.token = token;
            const _sign = base.sign(args);
            return base.post('/favorite/add', _sign.string);
        },
        delFavorite(token, sourceId) {
            const _sign = base.sign({
                token,
                id: sourceId
            });
            return base.post('/favorite/del', _sign.string);
        },
        moveFavoriteToGroup(token, articleIds, groupId) {
            const _sign = base.sign({
                token,
                fav_ids: articleIds.join(','),
                dest_id: groupId
            });
            return base.post('/favorite/groupMove', _sign.string);
        }
    };
};
