/**
 * 关键词订阅相关接口
 */
// const base = require('./base');

module.exports = function (base) {
    return {
        keywordsFollowList(token) {
            const _sign = base.sign({
                token
            });
            return base.get('/keywords/list', _sign.string);
        },
        addKeywordsFollow(token, keyword) {
            const _sign = base.sign({
                token,
                keyword
            });
            return base.post('/keywords/save', _sign.string);
        },
        updateKeywordsFollow(token, id, keyword) {
            const _sign = base.sign({
                token,
                id,
                keyword
            });
            return base.post('/keywords/save', _sign.string);
        },
        delKeywordsFollow(token, id) {
            const _sign = base.sign({
                token,
                id
            });
            return base.post('/keywords/del', _sign.string);
        },
        keywordsFollowArticles(token, q, page, order, contentType, days, q1) {
            const _sign = base.sign({
                token,
                q,
                page,
                order,
                content_type: contentType,
                days,
                q1,
            });
            return base.post('/keywords/articles', _sign.string);
        }
    };
};
