/**
 * 公用文章资源相关接口
 */
const moment = require('moment');

module.exports = function (base) {
    return {
        // 获取我关注公众号文章列表
        getMyFollowArticles(token, args = {}) {
            args.token = token;
            if (args.d) {
                args.d = moment(args.d).format('YYYYMMDD');
            }
            // if (groupId != undefined) {
            //     args.group_id = groupId;
            // }
            const _sign = base.sign(args);
            return base.get('/follow/article', _sign.string);
        },
        // 获取我关注公众号列表
        getMyFollowAccount(token) {
            const _sign = base.sign({
                token
            });
            return base.get('/follow/account', _sign.string);
        },
        // 获取我关注公众号列表-带分组
        getMyFollowAccountGroup(token) {
            const _sign = base.sign({
                token,
                is_all: '',
            });
            return base.get('/follow/groupsData', _sign.string);
        },
    };
};
