/**
 * 公用文章资源相关接口
 */
const moment = require('moment');

module.exports = function (base) {
    return {
        // 获取文章分类
        getPublcArticleCategories() {
            return base.get('/article/newCategory');
        },
        // 获取文章排行榜
        getPublickArticleTop(page, args = {}) {
            args.page = page;
            if (args.date) {
                args.date = moment(args.date).format('YYYYMMDD');
            }
            const _sign = base.sign(args);
            return base.get('/article/topArticle', _sign.string);
        },
        // 获取新文章排行榜
        getNewPublicArticleTop(page, args = {}) {
            args.page = page;
            const _sign = base.sign(args);
            return base.get('/article/rank', _sign.string);
        },
        // 获取爆文
        getPublickArticleHot(page, args = {}) {
            args.page = page;
            if (args.date) {
                args.date = moment(args.date).format('YYYY-MM-DD');
            }
            const _sign = base.sign(args);
            return base.get('/article/hotArticle', _sign.string);
        },
        // 获取优质文章
        getPublickArticleScoreTop(page, args = {}) {
            args.page = page;
            const _sign = base.sign(args);
            return base.get('/article/scoretop', _sign.string);
        },
        // 搜索文章
        publicArticleSearch(q, args = {}) {
            args.q = q;
            const _sign = base.sign(args);
            return base.get('/article/search', _sign.string);
        },
        getArticleDetail(token, id, args = {}) {
            args.id = id;
            const _sign = base.sign(args);
            return base.get('/article/detail', _sign.string);
        }
    };
};
