const fs = require('fs-extra');
const path = require('path');

module.exports = function (base) {
    return {
        deleteWxbmuti(materialDir) {
            return new Promise(function (resolve) {
                fs.emptydir(materialDir, (err) => {
                    resolve(!err ? 'success' : 'fail');
                });
            });
        },
        deleteAllDB(materialDir) {
            return new Promise(function (resolve) {
                fs.emptydir(path.join(materialDir, '/data'), (err) => {
                    resolve(!err ? 'success' : 'fail');
                });
            });
        },
        deleteDBList(materialDir, dbNameList) {
            return new Promise((resolve, reject) => {
                try {
                    dbNameList.forEach(dbName => {
                        const dbPath = path.join(materialDir, '/data', `/${dbName}.db`);
                        if (fs.existsSync(dbPath)) {
                            fs.unlinkSync(dbPath);
                        }
                        if (dbName === 'images') {
                            const list = fs.readdirSync(materialDir);
                            list.forEach(file => {
                                const curPath = path.join(materialDir, `/${file}`);
                                if (!fs.statSync(curPath).isDirectory()) {
                                    fs.unlinkSync(curPath);
                                }
                            });
                        }
                    });
                    resolve();
                } catch (e) {
                    reject(e);
                }
            });
        }
    };
};
