/**
 * 定时群发相关接口
 */
// const base = require('./base');

// 这部分接口都没有测试过，需要有文章和账号的情况下调试下

module.exports = function (base) {
    return {
        /**
         * args参数
         * raw_id: 公众号原始ID username： password：
         * mobile: 手机号码 send_time： news_id：素材ID title1: 首篇文章标题 total_count: 总文章数
         * wx_name: 微信公众号名称 wx_id: 微信号
         */
        addSendTimer(token, authId, mediaId, sendTime, args = {}) {
            // total_count:文章总数
            // title:首篇文章标题
            // desc: 首篇摘要
            // thumb_media_id:封面media_id
            args.token = token;
            args.auth_id = authId;
            args.media_id = mediaId;
            args.send_time = sendTime;
            args.source = 'multi';
            // args.msg_type mpnews图文消息<默认>
            const _sign = base.sign(args);
            return base.post('/authorizer/addSendTimer', _sign.string);
        },
        updateSendTimer(token, id, args = {}) {
            args.token = token;
            args.id = id;
            args.source = 'multi';
            const _sign = base.sign(args);
            return base.post('/authorizer/editSendTimer', _sign.string);
        },
        removeSendTimer(token, id) {
            const _sign = base.sign({
                token,
                id
            });
            return base.post('/authorizer/removeSend', _sign.string);
        },

        /**
         * getSendTimerList - description
         *
         * @param  {type} token     description
         * @param  {type} rawId     description
         * @param  {type} args = {} status: -1失败，0等待，1成功 page: 页码
         * @return {type}
         */
        getSendTimerList(token, args = {}) {
            args.token = token;
            const _sign = base.sign(args);
            return base.get('/authorizer/sendTimers', _sign.string);
        },
        // http://api.wxb.com/authorizer/sendTimerAuthorLists
        getSendTimerAcountList(token) {
            const _sign = base.sign({
                token
            });
            return base.get('/authorizer/sendTimerAuthorLists', _sign.string);
        },
        getWeiXinMaterial(token, authId, args = {}) {
            args.token = token;
            args.auth_id = authId;
            args.type = 'news';
            const _sign = base.sign(args);
            return base.post('/weixin/batchgetMaterial', _sign.string);
        }
    };
};
