/**
 * 我的常用模板相关接口
 */
// const base = require('./base');

module.exports = function (base) {
    return {
        getTemplate(token, id, type) {
            const _sign = base.sign({
                token,
                wx_origin_id: id,
                account_type: type
            });
            return base.get('/template/info', _sign.string);
        },
        setTemplate(token, originId, type, args = {}) {
            args.token = token;
            args.wx_origin_id = originId;
            args.account_type = type;
            const _sign = base.sign(args);
            return base.post('/template/save', _sign.string);
        }
    };
};
